package org.mule.connectivity.model.metadata.model;

import org.mule.connectivity.model.metadata.definition.CustomTypeDefinition;
import org.mule.connectivity.model.metadata.definition.SimpleTypeDefinition;

import javax.ws.rs.core.MediaType;

import static org.mule.connectivity.model.metadata.definition.SimpleTypeDefinition.PrimitiveType;


public class PrimitiveMetadataModel implements MetadataModel {

    private final MediaType mediaType;
    private final SimpleTypeDefinition type;

    public PrimitiveMetadataModel(String mediaType, String type) {
        this.mediaType = MediaType.valueOf(mediaType);
        this.type = new SimpleTypeDefinition(PrimitiveType.fromString(type));
    }

    public PrimitiveMetadataModel(String mediaType, PrimitiveType type) {
        this.mediaType = MediaType.valueOf(mediaType);
        this.type = new SimpleTypeDefinition(type);
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getModelName() {
        return type.getName();
    }

    @Override
    public CustomTypeDefinition getMetadataDefinition() {
        return null;
    }

}
