package org.mule.connectivity.model.operation;

import com.google.common.base.Joiner;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.parameter.PropertyParameter;
import org.mule.connectivity.model.metadata.MetadataModelFactory;
import org.raml.v2.api.model.v10.methods.Method;

import java.util.ArrayList;
import java.util.List;

import static org.apache.commons.lang.WordUtils.capitalize;
import static org.mule.connectivity.util.ParserUtils.getJavaName;
import static org.raml.v2.internal.utils.Inflector.lowercamelcase;


public class ConnectorOperation extends Operation {

    public ConnectorOperation(Method method) throws UnsupportedMediaTypeException {
        super(method);

        MetadataModelFactory metadataModelFactory = new MetadataModelFactory(method);
        inputMetaData = metadataModelFactory.constructInputMetadata(capitalize(getMethodName()) + "Request");
        outputMetaData = metadataModelFactory.constructOutputMetadata(capitalize(getMethodName()) + "Response");
    }

    public String getMethodName() {
        return getJavaName(canonicalName);
    }

    public String getTestClassName() {
        return capitalize(getMethodName()) + "TestCase";
    }

    public String getArguments() {
        List<String> stream = new ArrayList<>();

        // Parses the query params.
        for (PropertyParameter parameter : parameters) {
            StringBuilder sb = new StringBuilder();
            sb.append(parameter.isRequired() ? "" : "@Optional");
            sb.append(" ");
            sb.append(parameter.getType().getJavaType());
            sb.append(" ");
            sb.append(lowercamelcase(parameter.getJavaName()));
            stream.add(sb.toString());
        }

        // Parses the content entity.
        if (this.inputMetaData != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("@RefOnly @Default(\"#[payload]\") ");
            sb.append(getInputMetadataClassName());
            sb.append(" entity");
            stream.add(sb.toString());
        }

        return Joiner.on(", ").join(stream);
    }

    public String getInputMetadataClassName() {
        return this.inputMetaData.getMetadataDefinition() != null ? this.inputMetaData.getMetadataDefinition().getJavaType() : "String";
    }

    public String getOutputMetadataClassName() {
        return this.outputMetaData.getMetadataDefinition() != null ? this.outputMetaData.getMetadataDefinition().getJavaType() : "String";
    }

}
