package org.mule.connectivity.model.operation;

import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.metadata.MetadataModelFactory;
import org.mule.connectivity.model.parameter.PropertyParameter;
import org.raml.v2.api.model.v10.methods.Method;

import java.util.ArrayList;
import java.util.List;

import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.join;
import static org.mule.connectivity.util.ParserUtils.getXmlName;


public class SmartConnectorOperation extends Operation {

    public SmartConnectorOperation(Method method) throws UnsupportedMediaTypeException {
        super(method);

        MetadataModelFactory metadataModelFactory = new MetadataModelFactory(method);
        inputMetaData = metadataModelFactory.constructInputMetadata(getName() + "-request-type");
        outputMetaData = metadataModelFactory.constructOutputMetadata(getName() + "-response-type");
    }

    // Utility methods invoked from template

    public String getName() {
        return getXmlName(canonicalName);
    }

    public String getQueryParametersDW() {
        return getParametersDW(this.queryParameters);
    }

    public String getUriParametersDW() {
        return getParametersDW(this.uriParameters);
    }

    public String getHeadersDW() {
        return getParametersDW(this.headers);
    }

    public boolean hasInputParameters() {
        return this.inputMetaData != null || !this.parameters.isEmpty();
    }

    public String getInputMetadataParameterName() {
        return getName() + "-request-data";
    }

    private String getParametersDW(final List<PropertyParameter> parameters) {
        List<String> keys = new ArrayList<>();

        for (PropertyParameter parameter : parameters) {
            keys.add(format("'%s': parameters['%s']", parameter.getName(), parameter.getXmlName()));
        }

        return format("#[ { %s } filter $ != null ]", join(keys, ","));
    }

}
