package org.mule.connectivity.model.security;

import org.raml.v2.api.model.v10.security.SecurityScheme;

import java.util.List;

import static org.mule.connectivity.util.ParserUtils.getValueFromAnnotableString;

public class OAuth2Scheme implements APISecurityScheme {

    private static final String OAUTH2_CONFIG_TEMPLATE_VM = "templates/devkit/OAuth2Config.vm";
    private final String authorizationUri;
    private final String accessTokenUri;
    private final List<String> authorizationGrants;
    private final List<String> scopes;

    public OAuth2Scheme(SecurityScheme securityScheme) {
        authorizationUri = getValueFromAnnotableString( securityScheme.settings().authorizationUri());
        accessTokenUri = getValueFromAnnotableString( securityScheme.settings().accessTokenUri());
        authorizationGrants = securityScheme.settings().authorizationGrants();
        scopes = securityScheme.settings().scopes();
    }

    @Override
    public String getSchemeName() {
        return OAUTH2;
    }

    @Override
    public String getConfigurationName() {
        return "OAuth2Config.java";
    }

    @Override
    public String getTemplateLocation() {
        return OAUTH2_CONFIG_TEMPLATE_VM;
    }

    public String getAuthorizationUri() {
        return authorizationUri;
    }

    public String getAccessTokenUri() {
        return accessTokenUri;
    }

    public List<String> getAuthorizationGrants() {
        return authorizationGrants;
    }

    public List<String> getScopes() {
        return scopes;
    }

    public boolean supportsAuthorizationGrant(String authorizationGrant) {
        return authorizationGrants.contains(authorizationGrant);
    }
}
