package org.mule.connectivity.model.security;

import org.mule.connectivity.exception.UnsupportedSecuritySchemeException;
import org.raml.v2.api.model.v10.security.SecurityScheme;

import java.util.ArrayList;
import java.util.List;


public class SecuritySchemeFactory {

    public static List<APISecurityScheme> getSchemes(List<SecurityScheme> securitySchemes) throws UnsupportedSecuritySchemeException {
        List<APISecurityScheme> apiSecuritySchemes = new ArrayList<APISecurityScheme>();

        for (SecurityScheme securityScheme : securitySchemes) {
            APISecurityScheme apiSecurityScheme = createSecurityScheme(securityScheme);
            if(apiSecurityScheme != null)
                apiSecuritySchemes.add(apiSecurityScheme);
        }

        // If the API is secured but we don't support any defined schemes, then we must throw a generation exception.
        if(!securitySchemes.isEmpty() && apiSecuritySchemes.isEmpty())
            throw new UnsupportedSecuritySchemeException("None of the specified security schemes are supported.");

        // If the api is not secured, then we generate the unsecured config.
        if(securitySchemes.isEmpty())
            apiSecuritySchemes.add(new UnsecuredScheme());

        return apiSecuritySchemes;
    }

    private static APISecurityScheme createSecurityScheme(SecurityScheme securityScheme) {
        switch (securityScheme.type()) {
            case APISecurityScheme.BASIC:
                return new BasicAuthScheme();
            case APISecurityScheme.OAUTH2:
                return new OAuth2Scheme(securityScheme);
        }

        return null;
    }

}
