package org.mule.connectivity.mojo;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.connectivity.model.api.builder.ConnectorModelBuilder;
import org.mule.connectivity.model.api.ConnectorModel;

import java.io.File;

import static org.mule.connectivity.templateEngine.builder.DevKitTemplateEngineBuilder.createDevKitConnector;
import static org.mule.connectivity.util.MojoUtils.getMainRamlFile;


@Mojo(name = "raml2connector", defaultPhase = LifecyclePhase.GENERATE_SOURCES, requiresProject = false)
public class Raml2ConnectorMojo extends AbstractMojo {

    private Logger logger = LogManager.getLogger(Raml2ConnectorMojo.class);

    @Parameter(property = "raml", required = true)
    private String raml;

    @Parameter(property = "name")
    private String name;

    @Parameter(property = "outputDir", defaultValue = "target")
    private File outputDir;

    @Parameter(property = "category", defaultValue = "COMMUNITY")
    private String category;

    @Parameter(defaultValue = "${project}", readonly = true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            ConnectorModel model = ConnectorModelBuilder
                                        .createConnectorModel()
                                        .fromRaml(getMainRamlFile(raml))
                                        .withName(name)
                                        .withCategory(category)
                                        .build();

            createDevKitConnector()
                                        .fromModel(model)
                                        .inOutputDir(outputDir.toPath())
                                        .generateProjectFiles(generateProjectfiles())
                                        .execute();
        } catch (Exception e) {
            logger.error(e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }

    // Just generate project files when run without a project.
    private boolean generateProjectfiles() {
        return project.getBasedir() == null;
    }

}
