package org.mule.connectivity.mojo;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.connectivity.model.api.builder.SmartConnectorModelBuilder;
import org.mule.connectivity.model.api.SmartConnectorModel;

import java.io.File;

import static org.mule.connectivity.templateEngine.builder.SmartConnectorTemplateEngineBuilder.createSmartConnector;
import static org.mule.connectivity.util.MojoUtils.getMainRamlFile;


@Mojo(name = "raml2smartconnector", defaultPhase = LifecyclePhase.GENERATE_SOURCES, requiresProject = false)
public class Raml2SmartConnectorMojo extends AbstractMojo {

    private Logger logger = LogManager.getLogger(Raml2ConnectorMojo.class);

    @Parameter(property = "raml", required = true)
    private String raml;

    @Parameter(property = "name")
    private String name;

    @Parameter(property = "outputDir", defaultValue = "target")
    private File outputDir;


    public void execute() throws MojoExecutionException {
        try {
            SmartConnectorModel model = SmartConnectorModelBuilder
                                            .createSmartConnectorModel()
                                            .fromRaml(getMainRamlFile(raml))
                                            .withName(name)
                                            .build();

            createSmartConnector()
                                            .fromModel(model)
                                            .inOutputDir(outputDir.toPath())
                                            .execute();
        } catch (Exception e) {
            logger.error(e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }

}
