package org.mule.connectivity.predicate;

import com.google.common.base.Predicate;
import org.raml.v2.api.model.v10.datamodel.*;

import javax.annotation.Nullable;

import static org.mule.connectivity.model.metadata.MetadataModelFactory.*;


public class IsSupportedTypePredicate implements Predicate<TypeDeclaration> {

    @Override
    public boolean apply(@Nullable TypeDeclaration mediaType) {
        return typeIsDefinedWithRAML(mediaType) ||
               typeIsDefinedWithXMLSchema(mediaType) ||
               typeIsDefinedWithJSONSchema(mediaType) ||
               typeDefinitionIsNotProvided(mediaType) ||
               typeIsPrimitive(mediaType);
    }

}
