package org.mule.connectivity.predicate;

import com.google.common.base.Predicate;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;

import javax.annotation.Nullable;


public class OperationNamePredicate implements Predicate<AnnotationRef> {

    public static final String OPERATION_NAME_ANNOTATION = "operationName";

    @Override
    public boolean apply(@Nullable AnnotationRef input) {
        if(input == null)
            return false;

        return OPERATION_NAME_ANNOTATION.equals(input.annotation().name());
    }

}
