package org.mule.connectivity.templateEngine.builder;

import org.mule.connectivity.model.api.ConnectorModel;
import org.mule.connectivity.templateEngine.DevKitTemplateEngine;

public class DevKitTemplateEngineBuilder extends TemplateEngineBuilder<DevKitTemplateEngineBuilder, ConnectorModel> {

    private boolean generateProjectFiles = true;

    private DevKitTemplateEngineBuilder() {

    }

    public static DevKitTemplateEngineBuilder createDevKitConnector() {
        return new DevKitTemplateEngineBuilder();
    }

    public DevKitTemplateEngineBuilder generateProjectFiles(boolean generateProjectFiles) {
        this.generateProjectFiles = generateProjectFiles;
        return this;
    }

    public boolean getProjectFilesGeneration() {
        return generateProjectFiles;
    }

    @Override
    public void execute() throws Exception {
        DevKitTemplateEngine engine = new DevKitTemplateEngine(this);
        engine.applyTemplates();
    }

}
