package org.mule.connectivity.util;

import net.lingala.zip4j.exception.ZipException;
import org.mule.connectivity.exception.InvalidRAMLSourceException;

import java.io.File;
import java.io.FilenameFilter;

import static org.mule.connectivity.util.FileUtils.unzipFile;

public class MojoUtils {

    private MojoUtils() {

    }

    public static File getMainRamlFile(String ramlFileName) {
        File raml = new File(ramlFileName);

        // This looks for a valid RAML file inside a zip file.
        if(raml.getName().toLowerCase().endsWith(".zip")) {
            try {
                File tempDir = unzipFile(raml);
                raml = getRamlFile(tempDir);
            } catch (ZipException e) {
                throw new InvalidRAMLSourceException("Invalid zip file.");
            }
        }

        return raml.getAbsoluteFile();
    }

    // At the moment we only support one RAML file per directory.
    // (Note that there can be many other RAML files in subdirs).
    private static File getRamlFile(File dir) {
        File[] ramlFiles = dir.listFiles(new FilenameFilter() {

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".raml");
            }

        });

        if(ramlFiles.length == 0)
            throw new InvalidRAMLSourceException("The provided zip file doesn't contain any RAML files.");

        if(ramlFiles.length > 1)
            throw new InvalidRAMLSourceException("The provided zip file contains more than one RAML file.");

        return ramlFiles[0];
    }

}
