/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.metadata.definition;

import org.mule.connectivity.model.metadata.definition.CustomTypeDefinition;
import org.mule.connectivity.model.metadata.definition.TypeDefinition;

public class SimpleTypeDefinition
implements TypeDefinition {
    private final PrimitiveType type;

    public SimpleTypeDefinition(PrimitiveType name) {
        this.type = name;
    }

    @Override
    public String getName() {
        return this.type.toString();
    }

    @Override
    public String getMule4Type() {
        switch (this.type) {
            case INTEGER: {
                return "integer";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: {
                return "date";
            }
            case TIME_ONLY: {
                return "time";
            }
            case NUMBER: 
            case STRING: 
            case FILE: {
                return "string";
            }
        }
        throw new IllegalArgumentException("Invalid type value: " + this.type.toString());
    }

    @Override
    public String getJavaType() {
        switch (this.type) {
            case INTEGER: {
                return "Integer";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case NUMBER: {
                return "BigDecimal";
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: {
                return "Date";
            }
            case FILE: {
                return "File";
            }
            case STRING: {
                return "String";
            }
        }
        throw new IllegalArgumentException("Invalid type value: " + this.type.toString());
    }

    @Override
    public boolean isCustomType() {
        return false;
    }

    @Override
    public CustomTypeDefinition getCustomType() {
        return null;
    }

    public static enum PrimitiveType {
        BOOLEAN("boolean"),
        DATE("date"),
        DATE_ONLY("date-only"),
        DATE_TIME_ONLY("datetime-only"),
        DATE_TIME("datetime"),
        FILE("file"),
        NUMBER("number"),
        INTEGER("integer"),
        STRING("string"),
        TIME_ONLY("time-only");

        private final String type;

        private PrimitiveType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static PrimitiveType fromString(String type) {
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                if (!primitiveType.type.equalsIgnoreCase(type)) continue;
                return primitiveType;
            }
            throw new IllegalArgumentException("No enum constant with text " + type + ".");
        }
    }
}

