/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.mojo;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.connectivity.model.api.SmartConnectorModel;
import org.mule.connectivity.model.api.builder.SmartConnectorModelBuilder;
import org.mule.connectivity.mojo.Raml2ConnectorMojo;
import org.mule.connectivity.templateEngine.builder.SmartConnectorTemplateEngineBuilder;
import org.mule.connectivity.util.MojoUtils;

@Mojo(name="raml2smartconnector", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=false)
public class Raml2SmartConnectorMojo
extends AbstractMojo {
    private Logger logger = LogManager.getLogger(Raml2ConnectorMojo.class);
    @Parameter(property="raml", required=true)
    private String raml;
    @Parameter(property="name")
    private String name;
    @Parameter(property="outputDir", defaultValue="target")
    private File outputDir;

    public void execute() throws MojoExecutionException {
        try {
            SmartConnectorModel model = (SmartConnectorModel)((SmartConnectorModelBuilder)((SmartConnectorModelBuilder)SmartConnectorModelBuilder.createSmartConnectorModel().fromRaml(MojoUtils.getMainRamlFile(this.raml))).withName(this.name)).build();
            ((SmartConnectorTemplateEngineBuilder)((SmartConnectorTemplateEngineBuilder)SmartConnectorTemplateEngineBuilder.createSmartConnector().fromModel(model)).inOutputDir(this.outputDir.toPath())).execute();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }
}

