/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class TemplateEngine {
    private final Logger logger = LogManager.getLogger(TemplateEngine.class);

    public abstract void applyTemplates() throws Exception;

    protected void applyTemplate(String templateVm, Path output, VelocityContext context) throws Exception {
        output.getParent().toFile().mkdirs();
        context.put("StringUtils", StringUtils.class);
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.init();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(output.toFile()));){
            Template template = ve.getTemplate(templateVm, "UTF-8");
            this.logger.debug("Writing " + output.toString());
            template.merge((Context)context, (Writer)writer);
        }
    }
}

