/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.util;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.TreeTraverser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.model.operation.Operation;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class OperationMappingUtils {
    protected static final Logger logger = LogManager.getLogger(OperationMappingUtils.class);
    private static final TreeTraverser<Resource> TRAVERSER = new TreeTraverser<Resource>(){

        public Iterable<Resource> children(Resource root) {
            return root.resources();
        }
    };
    private static final String IGNORE_ANNOTATION = "ignored";

    public static List<Method> getMethods(Api api) {
        List resources = api.resources();
        return FluentIterable.from((Iterable)resources).transformAndConcat((Function)new Function<Resource, Iterable<Resource>>(){

            @Nullable
            public Iterable<Resource> apply(@Nullable Resource input) {
                return TRAVERSER.preOrderTraversal((Object)input);
            }
        }).transformAndConcat((Function)new Function<Resource, Iterable<Method>>(){

            @Nullable
            public Iterable<Method> apply(@Nullable Resource input) {
                return input.methods();
            }
        }).toList();
    }

    public static boolean isIgnored(Method method) {
        for (AnnotationRef annotationRef : method.annotations()) {
            if (!IGNORE_ANNOTATION.equals(annotationRef.annotation().name())) continue;
            return true;
        }
        return false;
    }

    public static void disambiguateRepeatedOperations(List<? extends Operation> operations) {
        HashSet<String> repeatedNames = new HashSet<String>();
        HashMap<String, Integer> replacedNames = new HashMap<String, Integer>();
        for (Operation operation : operations) {
            String name = operation.getCanonicalName();
            if (replacedNames.containsKey(name)) {
                repeatedNames.add(name);
                continue;
            }
            replacedNames.put(name, 0);
        }
        for (Operation operation : operations) {
            String operationName = operation.getCanonicalName();
            if (!repeatedNames.contains(operationName)) continue;
            int occurrences = (Integer)replacedNames.get(operationName) + 1;
            operation.setCanonicalName(String.format("%s_%d", operationName, occurrences));
            replacedNames.put(operationName, occurrences);
        }
    }
}

