/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.operation;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.metadata.model.MetadataModel;
import org.mule.connectivity.model.parameter.PropertyParameter;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public abstract class Operation {
    protected final String friendlyName;
    protected final String description;
    protected String canonicalName;
    protected final List<PropertyParameter> parameters;
    protected final List<PropertyParameter> uriParameters;
    protected final List<PropertyParameter> queryParameters;
    protected final List<PropertyParameter> headers;
    protected MetadataModel inputMetaData;
    protected MetadataModel outputMetaData;
    protected final String httpMethod;
    protected final String uri;

    public Operation(Method method) throws UnsupportedMediaTypeException {
        this.friendlyName = ParserUtils.getMethodDisplayName(method);
        this.description = ParserUtils.getMethodDescription(method);
        this.canonicalName = ParserUtils.getCanonicalOperationName(method, this);
        this.httpMethod = method.method();
        this.uriParameters = this.buildUriParams(method);
        this.queryParameters = this.buildQueryParams(method);
        this.headers = this.buildHeaders(method);
        this.uri = method.resource().resourcePath();
        this.parameters = FluentIterable.from((Iterable)Iterables.concat(this.queryParameters, this.uriParameters, this.headers)).toList();
    }

    private List<PropertyParameter> buildQueryParams(Method method) {
        return this.getParameterList(method.queryParameters());
    }

    private List<PropertyParameter> buildUriParams(Method method) {
        ArrayList<PropertyParameter> uriParameters = new ArrayList<PropertyParameter>();
        for (Resource resource = method.resource(); resource != null; resource = resource.parentResource()) {
            uriParameters.addAll(0, this.getParameterList(resource.uriParameters()));
        }
        return uriParameters;
    }

    private List<PropertyParameter> buildHeaders(Method method) {
        return this.getParameterList(method.headers());
    }

    private ArrayList<PropertyParameter> getParameterList(List<TypeDeclaration> typeDeclarationParameters) {
        return Lists.newArrayList((Iterable)Iterables.transform(typeDeclarationParameters, (Function)new PropertyParameter.ParameterTransformFunction()));
    }

    public boolean hasQueryParameters() {
        return !this.queryParameters.isEmpty();
    }

    public boolean hasUriParameters() {
        return !this.uriParameters.isEmpty();
    }

    public boolean hasHeaders() {
        return !this.headers.isEmpty();
    }

    public List<PropertyParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<PropertyParameter> getUriParameters() {
        return this.uriParameters;
    }

    public List<PropertyParameter> getHeaders() {
        return this.headers;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUri() {
        return this.uri;
    }

    public Iterable<PropertyParameter> getParameters() {
        return this.parameters;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public MetadataModel getInputMetaData() {
        return this.inputMetaData;
    }

    public MetadataModel getOutputMetaData() {
        return this.outputMetaData;
    }
}

