/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.security;

import java.util.List;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.security.SecurityScheme;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;

public class OAuth2Scheme
implements APISecurityScheme {
    private static final String OAUTH2_CONFIG_TEMPLATE_VM = "templates/devkit/OAuth2Config.vm";
    private final String authorizationUri;
    private final String accessTokenUri;
    private final List<String> authorizationGrants;
    private final List<String> scopes;

    public OAuth2Scheme(SecurityScheme securityScheme) {
        this.authorizationUri = ParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().authorizationUri());
        this.accessTokenUri = ParserUtils.getValueFromAnnotableString((AnnotableStringType)securityScheme.settings().accessTokenUri());
        this.authorizationGrants = securityScheme.settings().authorizationGrants();
        this.scopes = securityScheme.settings().scopes();
    }

    @Override
    public String getSchemeName() {
        return "OAuth 2.0";
    }

    @Override
    public String getConfigurationName() {
        return "OAuth2Config.java";
    }

    @Override
    public String getTemplateLocation() {
        return OAUTH2_CONFIG_TEMPLATE_VM;
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public List<String> getAuthorizationGrants() {
        return this.authorizationGrants;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean supportsAuthorizationGrant(String authorizationGrant) {
        return this.authorizationGrants.contains(authorizationGrant);
    }
}

