/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.security;

import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.model.security.BasicAuthScheme;
import org.mule.connectivity.model.security.OAuth2Scheme;
import org.mule.connectivity.model.security.UnsecuredScheme;
import org.raml.v2.api.model.v10.security.SecurityScheme;

public class SecuritySchemeFactory {
    public static List<APISecurityScheme> getSchemes(List<SecurityScheme> securitySchemes) throws UnsupportedSecuritySchemeException {
        ArrayList<APISecurityScheme> apiSecuritySchemes = new ArrayList<APISecurityScheme>();
        for (SecurityScheme securityScheme : securitySchemes) {
            APISecurityScheme apiSecurityScheme = SecuritySchemeFactory.createSecurityScheme(securityScheme);
            if (apiSecurityScheme == null) continue;
            apiSecuritySchemes.add(apiSecurityScheme);
        }
        if (!securitySchemes.isEmpty() && apiSecuritySchemes.isEmpty()) {
            throw new UnsupportedSecuritySchemeException("None of the specified security schemes ( " + SecuritySchemeFactory.listSchemes(securitySchemes) + ") are supported.");
        }
        if (securitySchemes.isEmpty()) {
            apiSecuritySchemes.add(new UnsecuredScheme());
        }
        return apiSecuritySchemes;
    }

    private static APISecurityScheme createSecurityScheme(SecurityScheme securityScheme) {
        switch (securityScheme.type()) {
            case "Basic Authentication": {
                return new BasicAuthScheme();
            }
            case "OAuth 2.0": {
                return new OAuth2Scheme(securityScheme);
            }
        }
        return null;
    }

    private static String listSchemes(List<SecurityScheme> securitySchemes) {
        StringBuilder builder = new StringBuilder();
        for (SecurityScheme securityScheme : securitySchemes) {
            builder.append(securityScheme.name());
            if (securityScheme.type().equals("OAuth 2.0")) {
                builder.append(" :");
                for (String grant : securityScheme.settings().authorizationGrants()) {
                    builder.append(" ");
                    builder.append(grant);
                }
            }
            builder.append(". ");
        }
        return builder.toString();
    }
}

