/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.mojo;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.connectivity.model.api.ConnectorModel;
import org.mule.connectivity.model.api.builder.ConnectorModelBuilder;
import org.mule.connectivity.templateEngine.builder.DevKitTemplateEngineBuilder;
import org.mule.connectivity.util.MojoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="raml2connector", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=false)
public class Raml2ConnectorMojo
extends AbstractMojo {
    private Logger logger = LoggerFactory.getLogger(Raml2ConnectorMojo.class);
    @Parameter(property="raml", required=true)
    private String raml;
    @Parameter(property="name")
    private String name;
    @Parameter(property="outputDir", defaultValue="target")
    private File outputDir;
    @Parameter(property="category", defaultValue="COMMUNITY")
    private String category;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            ConnectorModel model = (ConnectorModel)((ConnectorModelBuilder)((ConnectorModelBuilder)ConnectorModelBuilder.createConnectorModel().fromRaml(MojoUtils.getMainRamlFile(this.raml))).withName(this.name)).withCategory(this.category).build();
            ((DevKitTemplateEngineBuilder)((DevKitTemplateEngineBuilder)DevKitTemplateEngineBuilder.createDevKitConnector().fromModel(model)).inOutputDir(this.outputDir.toPath())).generateProjectFiles(this.generateProjectfiles()).execute();
        }
        catch (Exception e) {
            this.logger.error("Failed to build connector.", (Throwable)e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }

    private boolean generateProjectfiles() {
        return this.project.getBasedir() == null;
    }
}

