/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.mule.connectivity.model.api.ConnectorModel;
import org.mule.connectivity.model.metadata.definition.CustomTypeDefinition;
import org.mule.connectivity.model.operation.ConnectorOperation;
import org.mule.connectivity.model.parameter.PropertyParameter;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.templateEngine.TemplateEngine;
import org.mule.connectivity.templateEngine.builder.DevKitTemplateEngineBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevKitTemplateEngine
extends TemplateEngine {
    private static final String CONNECTOR = "connector";
    private static final String OPERATION = "operation";
    private static final String BASE_URI = "baseUri";
    private static final String CONNECTOR_TEMPLATE_VM = "templates/devkit/ConnectorTemplate.vm";
    private static final String REST_CLIENT_CONFIG_PROVIDER_VM = "templates/devkit/RestClientConfigProvider.vm";
    private static final String FUNCTIONAL_TEST_CASE_VM = "templates/devkit/FunctionalTestCase.vm";
    private static final String ABSTRACT_TEST_CASE_VM = "templates/devkit/AbstractTestCases.vm";
    private static final String ABSTRACT_CONFIG_VM = "templates/devkit/AbstractConfig.vm";
    private static final String POM_VM = "templates/devkit/pom.vm";
    private static final String LICENSE_MD_VM = "templates/devkit/LICENSE.md";
    private static final Path MAIN_DIR = Paths.get("src/main/java/", new String[0]);
    private static final Path TEST_DIR = Paths.get("src/test/java/", new String[0]);
    private final ConnectorModel model;
    private final Path outputDir;
    private final boolean generateProjectFiles;
    private final Logger logger = LoggerFactory.getLogger(DevKitTemplateEngine.class);

    public DevKitTemplateEngine(DevKitTemplateEngineBuilder builder) {
        this.model = (ConnectorModel)builder.getModel();
        this.generateProjectFiles = builder.getProjectFilesGeneration();
        this.outputDir = builder.getOutputDir();
    }

    @Override
    public void applyTemplates() throws Exception {
        this.createPOJOs();
        this.createConnector();
    }

    private void createPOJOs() throws URISyntaxException {
        Path output = this.outputDir.resolve(MAIN_DIR);
        output.toFile().mkdirs();
        for (ConnectorOperation op : this.model.getOperations()) {
            try {
                if (op.getInputMetaData() != null && op.getInputMetaData().getMetadataDefinition() != null) {
                    op.getInputMetaData().getMetadataDefinition().generatePojo(op.getMethodName() + "Request", output.toFile(), this.model.getBasePackage());
                }
                if (op.getOutputMetaData() != null && op.getOutputMetaData().getMetadataDefinition() != null) {
                    op.getOutputMetaData().getMetadataDefinition().generatePojo(op.getMethodName() + "Response", output.toFile(), this.model.getBasePackage());
                }
                for (PropertyParameter parameter : op.getParameters()) {
                    if (!parameter.getType().isCustomType()) continue;
                    ((CustomTypeDefinition)parameter.getType()).generatePojo(op.getMethodName() + parameter.getJavaClassName(), output.toFile(), this.model.getBasePackage());
                }
            }
            catch (IOException e) {
                this.logger.warn("Error while creating POJO file: %s", (Object)op.getMethodName());
            }
        }
    }

    private void createConnector() throws Exception {
        VelocityContext context = new VelocityContext();
        context.internalPut(CONNECTOR, (Object)this.model);
        if (StringUtils.isNotBlank((String)this.model.getBaseUri())) {
            context.internalPut(BASE_URI, (Object)this.model.getBaseUri());
        }
        Path outputBaseDir = this.outputDir;
        Path packagePath = Paths.get(this.model.getBasePackage().replace('.', File.separatorChar), new String[0]);
        Path mainDir = outputBaseDir.resolve(MAIN_DIR).resolve(packagePath);
        Path testDir = outputBaseDir.resolve(TEST_DIR).resolve(packagePath).resolve("automation/functional");
        for (APISecurityScheme securityScheme : this.model.getSecuritySchemes()) {
            this.applyTemplate(securityScheme.getTemplateLocation(), mainDir.resolve(securityScheme.getConfigurationName()), context);
        }
        this.applyTemplate(CONNECTOR_TEMPLATE_VM, mainDir.resolve(this.model.getClassName() + ".java"), context);
        this.applyTemplate(ABSTRACT_CONFIG_VM, mainDir.resolve("AbstractConfig.java"), context);
        this.applyTemplate(REST_CLIENT_CONFIG_PROVIDER_VM, mainDir.resolve("RestClientConfigProvider.java"), context);
        this.applyTemplate(LICENSE_MD_VM, outputBaseDir.resolve("LICENSE.md"), context);
        if (this.generateProjectFiles) {
            this.applyTemplate(POM_VM, outputBaseDir.resolve("pom.xml"), context);
        }
        this.applyTemplate(ABSTRACT_TEST_CASE_VM, testDir.resolve("AbstractTestCases.java"), context);
        for (ConnectorOperation op : this.model.getOperations()) {
            context.internalPut(OPERATION, (Object)op);
            this.applyTemplate(FUNCTIONAL_TEST_CASE_VM, testDir.resolve(op.getTestClassName() + ".java"), context);
        }
    }
}

