/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolManager;
import org.mule.connectivity.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.model.api.SmartConnectorModel;
import org.mule.connectivity.model.metadata.definition.CustomTypeDefinition;
import org.mule.connectivity.model.operation.SmartConnectorOperation;
import org.mule.connectivity.model.parameter.PropertyParameter;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.model.security.BasicAuthScheme;
import org.mule.connectivity.model.security.OAuth2Scheme;
import org.mule.connectivity.templateEngine.TemplateEngine;
import org.mule.connectivity.templateEngine.builder.SmartConnectorTemplateEngineBuilder;

public class SmartConnectorTemplateEngine
extends TemplateEngine {
    private static final String SUPPORTS_BASIC_AUTH = "SUPPORTS_BASIC_AUTH";
    private static final String SUPPORTS_OAUTH2 = "SUPPORTS_OAUTH2";
    private static final String SUPPORTS_OAUTH2_CLIENT_CREDENTIALS = "SUPPORTS_OAUTH2_CLIENT_CREDENTIALS";
    private static final String EXTENSION = "extension";
    private static final String CATALOG_VM = "templates/smartConnector/catalog.vm";
    private static final String MODULE_VM = "templates/smartConnector/module.vm";
    private static final String POM_VM = "templates/smartConnector/pom.vm";
    private static final Path RESOURCES_DIR = Paths.get("src/main/resources", new String[0]);
    private static final String PROPERTIES_RESOURCE = "/project.properties";
    private static final String APPLICATION_PROPERTIES = "properties";
    private final SmartConnectorModel model;
    private final Path outputDir;

    public SmartConnectorTemplateEngine(SmartConnectorTemplateEngineBuilder builder) {
        this.model = (SmartConnectorModel)builder.getModel();
        this.outputDir = builder.getOutputDir();
    }

    @Override
    public void applyTemplates() throws Exception {
        this.generateXmls();
        this.generateCatalog();
    }

    private void generateCatalog() throws IOException {
        Path outputResourcesDir = this.outputDir.resolve(RESOURCES_DIR);
        for (SmartConnectorOperation operation : this.model.getOperations()) {
            if (operation.getInputMetaData() != null && operation.getInputMetaData().getMetadataDefinition() != null) {
                operation.getInputMetaData().getMetadataDefinition().writeSchema(outputResourcesDir);
            }
            if (operation.getOutputMetaData() != null && operation.getOutputMetaData().getMetadataDefinition() != null) {
                operation.getOutputMetaData().getMetadataDefinition().writeSchema(outputResourcesDir);
            }
            for (PropertyParameter parameter : operation.getParameters()) {
                if (!parameter.getType().isCustomType()) continue;
                ((CustomTypeDefinition)parameter.getType()).writeSchema(outputResourcesDir);
            }
        }
    }

    private void generateXmls() throws Exception {
        ToolManager velocityToolManager = new ToolManager();
        velocityToolManager.configure("velocity-tools.xml");
        VelocityContext context = new VelocityContext((Context)velocityToolManager.createContext());
        context.internalPut(EXTENSION, (Object)this.model);
        context.internalPut(APPLICATION_PROPERTIES, (Object)this.getApplicationProperties());
        for (APISecurityScheme securityScheme : this.model.getSecuritySchemes()) {
            if (securityScheme instanceof BasicAuthScheme) {
                context.internalPut(SUPPORTS_BASIC_AUTH, (Object)true);
            }
            if (!(securityScheme instanceof OAuth2Scheme)) continue;
            context.internalPut(SUPPORTS_OAUTH2, (Object)true);
            if (!((OAuth2Scheme)securityScheme).supportsAuthorizationGrant("client_credentials")) continue;
            context.internalPut(SUPPORTS_OAUTH2_CLIENT_CREDENTIALS, (Object)true);
        }
        if (!context.internalContainsKey((Object)SUPPORTS_BASIC_AUTH) && context.internalContainsKey((Object)SUPPORTS_OAUTH2) && !context.internalContainsKey((Object)SUPPORTS_OAUTH2_CLIENT_CREDENTIALS)) {
            String grants = this.getGrants(((SmartConnectorModel)context.get(EXTENSION)).getSecuritySchemes());
            throw new UnsupportedSecuritySchemeException("Only OAuth 2.0 grant type supported is Client Credentials. ( " + grants + " not supported )");
        }
        Path outputResourcesDir = this.outputDir.resolve(RESOURCES_DIR);
        this.applyTemplate(POM_VM, this.outputDir.resolve("pom.xml"), context);
        this.applyTemplate(MODULE_VM, outputResourcesDir.resolve(String.format("module-%s.xml", this.model.getModulePrefix())), context);
        this.applyTemplate(CATALOG_VM, outputResourcesDir.resolve(String.format("module-%s-catalog.xml", this.model.getModulePrefix())), context);
    }

    private Properties getApplicationProperties() throws IOException {
        try (InputStream input = this.getClass().getResourceAsStream(PROPERTIES_RESOURCE);){
            Properties prop = new Properties();
            prop.load(input);
            Properties properties = prop;
            return properties;
        }
    }

    private String getGrants(List<APISecurityScheme> schemas) {
        ArrayList<String> grants = new ArrayList<String>();
        for (APISecurityScheme schema : schemas) {
            if (!(schema instanceof OAuth2Scheme)) continue;
            for (String grant : ((OAuth2Scheme)schema).getAuthorizationGrants()) {
                grants.add(grant);
            }
        }
        return StringUtils.join(grants, (String)", ");
    }
}

