/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine;

import com.google.googlejavaformat.java.Formatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.mule.connectivity.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.model.security.BasicAuthScheme;
import org.mule.connectivity.model.security.OAuth2Scheme;
import org.mule.connectivity.templateEngine.TemplateEngine;
import org.mule.connectivity.templateEngine.builder.DevKitTemplateEngineBuilder;
import org.mule.connectivity.templateEngine.decorator.model.ConnectorModelDecorator;
import org.mule.connectivity.templateEngine.decorator.operation.ConnectorOperationDecorator;
import org.mule.connectivity.templateEngine.decorator.type.ConnectorTypeDefinitionDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevKitTemplateEngine
extends TemplateEngine {
    private static final String CONNECTOR = "connector";
    private static final String OPERATION = "operation";
    private static final String BASE_URI = "baseUri";
    private static final String SUPPORTS_BASIC_AUTH = "SUPPORTS_BASIC_AUTH";
    private static final String SUPPORTS_OAUTH2 = "SUPPORTS_OAUTH2";
    private static final String SUPPORTS_OAUTH2_CLIENT_CREDENTIALS = "SUPPORTS_OAUTH2_CLIENT_CREDENTIALS";
    private static final String CONNECTOR_TEMPLATE_VM = "templates/devkit/ConnectorTemplate.vm";
    private static final String REST_CLIENT_CONFIG_PROVIDER_VM = "templates/devkit/RestClientConfigProvider.vm";
    private static final String FUNCTIONAL_TEST_CASE_VM = "templates/devkit/FunctionalTestCase.vm";
    private static final String ABSTRACT_TEST_CASE_VM = "templates/devkit/AbstractTestCases.vm";
    private static final String ABSTRACT_CONFIG_VM = "templates/devkit/AbstractConfig.vm";
    private static final String POM_VM = "templates/devkit/pom.vm";
    private static final String LICENSE_MD_VM = "templates/devkit/LICENSE.md";
    private static final Path MAIN_DIR = Paths.get("src/main/java/", new String[0]);
    private static final Path TEST_DIR = Paths.get("src/test/java/", new String[0]);
    private final ConnectorModelDecorator model;
    private final Path outputDir;
    private final boolean generateProjectFiles;
    private final Logger logger = LoggerFactory.getLogger(DevKitTemplateEngine.class);

    public DevKitTemplateEngine(DevKitTemplateEngineBuilder builder) {
        this.model = new ConnectorModelDecorator(builder.getModel());
        this.generateProjectFiles = builder.getProjectFilesGeneration();
        this.outputDir = builder.getOutputDir();
    }

    @Override
    public void applyTemplates() throws Exception {
        this.createPojos();
        this.createConnector();
    }

    private void createPojos() throws IOException {
        Path output = this.outputDir.resolve(MAIN_DIR);
        output.toFile().mkdirs();
        for (ConnectorOperationDecorator operation : this.model.getDecoratedOperations()) {
            try {
                if (operation.getDecoratedInputMetadata() != null && operation.getDecoratedInputMetadata().requiresPojo()) {
                    operation.getDecoratedInputMetadata().generatePojo(output);
                }
                if (operation.getDecoratedOutputMetadata() != null && operation.getDecoratedOutputMetadata().requiresPojo()) {
                    operation.getDecoratedOutputMetadata().generatePojo(output);
                }
                for (ConnectorTypeDefinitionDecorator parameter : operation.getDecoratedParameters()) {
                    if (!parameter.requiresPojo()) continue;
                    parameter.generatePojo(output);
                }
            }
            catch (IOException e) {
                this.logger.warn("Error while creating POJO file: %s", (Object)operation.getMethodName());
            }
        }
    }

    private void createConnector() throws Exception {
        VelocityContext context = new VelocityContext();
        context.internalPut(CONNECTOR, (Object)this.model);
        if (this.model.getBaseUri() != null) {
            context.internalPut(BASE_URI, (Object)this.model.getBaseUriAsString());
        }
        Path outputBaseDir = this.outputDir;
        Path packagePath = Paths.get(this.model.getBasePackage().replace('.', File.separatorChar), new String[0]);
        Path mainDir = outputBaseDir.resolve(MAIN_DIR).resolve(packagePath);
        Path testDir = outputBaseDir.resolve(TEST_DIR).resolve(packagePath).resolve("automation/functional");
        for (APISecurityScheme securityScheme : this.model.getSecuritySchemes()) {
            if (securityScheme instanceof BasicAuthScheme) {
                context.internalPut(SUPPORTS_BASIC_AUTH, (Object)true);
            }
            if (securityScheme instanceof OAuth2Scheme) {
                context.internalPut(SUPPORTS_OAUTH2, (Object)true);
                if (((OAuth2Scheme)securityScheme).supportsAuthorizationGrant("client_credentials")) {
                    context.internalPut(SUPPORTS_OAUTH2_CLIENT_CREDENTIALS, (Object)true);
                }
            }
            this.applyTemplate(securityScheme.getTemplateLocation(), mainDir.resolve(securityScheme.getConfigurationName()), context);
        }
        if (!context.internalContainsKey((Object)SUPPORTS_BASIC_AUTH) && context.internalContainsKey((Object)SUPPORTS_OAUTH2) && !context.internalContainsKey((Object)SUPPORTS_OAUTH2_CLIENT_CREDENTIALS)) {
            String grants = this.getGrants(this.model.getSecuritySchemes());
            throw new UnsupportedSecuritySchemeException("Only OAuth 2.0 grant type supported is Client Credentials. ( " + grants + " not supported )");
        }
        this.applyTemplate(CONNECTOR_TEMPLATE_VM, mainDir.resolve(this.model.getClassName() + ".java"), context);
        this.applyTemplate(ABSTRACT_CONFIG_VM, mainDir.resolve("AbstractConfig.java"), context);
        this.applyTemplate(REST_CLIENT_CONFIG_PROVIDER_VM, mainDir.resolve("RestClientConfigProvider.java"), context);
        this.applyTemplate(LICENSE_MD_VM, outputBaseDir.resolve("LICENSE.md"), context);
        if (this.generateProjectFiles) {
            this.applyTemplate(POM_VM, outputBaseDir.resolve("pom.xml"), context);
        }
        this.applyTemplate(ABSTRACT_TEST_CASE_VM, testDir.resolve("AbstractTestCases.java"), context);
        for (ConnectorOperationDecorator op : this.model.getDecoratedOperations()) {
            context.internalPut(OPERATION, (Object)op);
            this.applyTemplate(FUNCTIONAL_TEST_CASE_VM, testDir.resolve(op.getTestClassName() + ".java"), context);
        }
    }

    @Override
    protected void applyTemplate(String templateVm, Path output, VelocityContext context) throws Exception {
        super.applyTemplate(templateVm, output, context);
        if (output.toString().endsWith(".java")) {
            this.javaFormat(output);
        }
    }

    private void javaFormat(Path filepath) throws IOException {
        String formattedSource = null;
        try {
            File file = filepath.toFile();
            String content = new String(Files.readAllBytes(filepath), "UTF-8");
            formattedSource = new Formatter().formatSource(content);
            file.delete();
        }
        catch (Exception e) {
            this.logger.error("Could not format file " + filepath.toString(), (Throwable)e);
            return;
        }
        Files.write(filepath, formattedSource.getBytes("UTF-8"), new OpenOption[0]);
    }

    private String getGrants(List<APISecurityScheme> schemas) {
        ArrayList<String> grants = new ArrayList<String>();
        for (APISecurityScheme schema : schemas) {
            if (!(schema instanceof OAuth2Scheme)) continue;
            for (String grant : ((OAuth2Scheme)schema).getAuthorizationGrants()) {
                grants.add(grant);
            }
        }
        return StringUtils.join(grants, (String)", ");
    }
}

