/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.operation;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.metadata.TypeDefinitionFactory;
import org.mule.connectivity.model.parameter.TypeDefinition;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class Operation {
    private final String friendlyName;
    private final String description;
    private String canonicalName;
    private final Map<String, TypeDefinition> uriParameters;
    private final Map<String, TypeDefinition> queryParameters;
    private final Map<String, TypeDefinition> headers;
    private final Map<String, TypeDefinition> parameters;
    private final TypeDefinition inputMetadata;
    private final TypeDefinition outputMetadata;
    private final String httpMethod;
    private final String uri;

    public Operation(Method method) throws UnsupportedMediaTypeException {
        this.friendlyName = ParserUtils.getMethodDisplayName(method);
        this.description = ParserUtils.getMethodDescription(method);
        this.canonicalName = ParserUtils.getCanonicalOperationName(method, this);
        this.httpMethod = method.method();
        this.uriParameters = this.buildUriParams(method);
        this.queryParameters = this.buildQueryParams(method);
        this.headers = this.buildHeaders(method);
        this.parameters = this.buildParameters();
        this.uri = method.resource().resourcePath();
        TypeDefinitionFactory typeDefinitionFactory = new TypeDefinitionFactory(method);
        this.inputMetadata = typeDefinitionFactory.constructInputMetadata();
        this.outputMetadata = typeDefinitionFactory.constructOutputMetadata();
    }

    private Map<String, TypeDefinition> buildParameters() {
        return new ImmutableMap.Builder().putAll(this.queryParameters).putAll(this.uriParameters).putAll(this.headers).build();
    }

    private Map<String, TypeDefinition> buildQueryParams(Method method) {
        return this.getParameterList(method.queryParameters());
    }

    private Map<String, TypeDefinition> buildUriParams(Method method) {
        ArrayList<Map<String, TypeDefinition>> maps = new ArrayList<Map<String, TypeDefinition>>();
        for (Resource resource = method.resource(); resource != null; resource = resource.parentResource()) {
            maps.add(0, this.getParameterList(resource.uriParameters()));
        }
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (Map map : maps) {
            mapBuilder.putAll(map);
        }
        return mapBuilder.build();
    }

    private Map<String, TypeDefinition> buildHeaders(Method method) {
        return this.getParameterList(method.headers());
    }

    private Map<String, TypeDefinition> getParameterList(List<TypeDeclaration> typeDeclarationParameters) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (TypeDeclaration typeDeclaration : typeDeclarationParameters) {
            mapBuilder.put((Object)typeDeclaration.name(), (Object)TypeDefinitionFactory.getTypeDefinition(typeDeclaration));
        }
        return mapBuilder.build();
    }

    public Map<String, TypeDefinition> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, TypeDefinition> getUriParameters() {
        return this.uriParameters;
    }

    public Map<String, TypeDefinition> getHeaders() {
        return this.headers;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, TypeDefinition> getParameters() {
        return this.parameters;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public TypeDefinition getInputMetadata() {
        return this.inputMetadata;
    }

    public TypeDefinition getOutputMetadata() {
        return this.outputMetadata;
    }
}

