/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine.decorator.operation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.model.parameter.TypeDefinition;
import org.mule.connectivity.templateEngine.decorator.operation.OperationDecorator;
import org.mule.connectivity.templateEngine.decorator.type.ConnectorTypeDefinitionDecorator;
import org.mule.connectivity.util.ParserUtils;

public class ConnectorOperationDecorator
extends OperationDecorator {
    private final String basePackage;
    private final ConnectorTypeDefinitionDecorator inputMetadata;
    private final ConnectorTypeDefinitionDecorator outputMetadata;
    private final List<ConnectorTypeDefinitionDecorator> queryParameters;
    private final List<ConnectorTypeDefinitionDecorator> uriParameters;
    private final List<ConnectorTypeDefinitionDecorator> parameters;
    private final List<ConnectorTypeDefinitionDecorator> headers;

    public ConnectorOperationDecorator(Operation operation, String basePackage) {
        super(operation);
        this.basePackage = basePackage;
        this.inputMetadata = this.buildInputMetadata();
        this.outputMetadata = this.buildOutputMetadata();
        this.queryParameters = this.buildDecoratedQueryParameters();
        this.uriParameters = this.buildDecoratedUriParameters();
        this.headers = this.buildDecoratedHeaders();
        this.parameters = this.buildDecoratedParameters();
    }

    private ConnectorTypeDefinitionDecorator buildInputMetadata() {
        if (this.getInputMetadata() == null) {
            return null;
        }
        ConnectorTypeDefinitionDecorator inputMetadata = new ConnectorTypeDefinitionDecorator(this.getInputMetadata(), this.basePackage);
        inputMetadata.setClassName(WordUtils.capitalize((String)this.getMethodName()) + "Request");
        return inputMetadata;
    }

    private ConnectorTypeDefinitionDecorator buildOutputMetadata() {
        if (this.getOutputMetadata() == null) {
            return null;
        }
        ConnectorTypeDefinitionDecorator outputMetadata = new ConnectorTypeDefinitionDecorator(this.getOutputMetadata(), this.basePackage);
        outputMetadata.setClassName(WordUtils.capitalize((String)this.getMethodName()) + "Response");
        return outputMetadata;
    }

    private List<ConnectorTypeDefinitionDecorator> buildDecoratedUriParameters() {
        return this.buildParameters(this.getUriParameters());
    }

    private List<ConnectorTypeDefinitionDecorator> buildDecoratedQueryParameters() {
        return this.buildParameters(this.getQueryParameters());
    }

    private List<ConnectorTypeDefinitionDecorator> buildDecoratedHeaders() {
        return this.buildParameters(this.getHeaders());
    }

    private List<ConnectorTypeDefinitionDecorator> buildParameters(Map<String, TypeDefinition> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameterName : parameters.keySet()) {
            builder.add((Object)new ConnectorTypeDefinitionDecorator(parameterName, parameters.get(parameterName), this.basePackage));
        }
        return builder.build();
    }

    private List<ConnectorTypeDefinitionDecorator> buildDecoratedParameters() {
        return ImmutableList.builder().addAll(this.uriParameters).addAll(this.queryParameters).addAll(this.headers).build();
    }

    public String getMethodName() {
        return ParserUtils.getJavaName(this.operation.getCanonicalName());
    }

    public String getTestClassName() {
        return WordUtils.capitalize((String)this.getMethodName()) + "TestCase";
    }

    public String getArguments() throws IOException {
        ArrayList<String> stream = new ArrayList<String>();
        for (ConnectorTypeDefinitionDecorator parameter : this.getDecoratedParameters()) {
            StringBuilder sb = new StringBuilder();
            sb.append(parameter.isRequired() ? "" : "@Optional");
            sb.append(" ");
            sb.append(parameter.getClassName());
            sb.append(" ");
            sb.append(parameter.getName());
            stream.add(sb.toString());
        }
        if (this.operation.getInputMetadata() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("@RefOnly @Default(\"#[payload]\") ");
            sb.append(this.getDecoratedInputMetadata().getClassName());
            sb.append(" entity");
            stream.add(sb.toString());
        }
        return Joiner.on((String)", ").join(stream);
    }

    public ConnectorTypeDefinitionDecorator getDecoratedInputMetadata() {
        return this.inputMetadata;
    }

    public ConnectorTypeDefinitionDecorator getDecoratedOutputMetadata() {
        return this.outputMetadata;
    }

    public List<ConnectorTypeDefinitionDecorator> getDecoratedQueryParameters() {
        return this.queryParameters;
    }

    public List<ConnectorTypeDefinitionDecorator> getDecoratedUriParameters() {
        return this.uriParameters;
    }

    public List<ConnectorTypeDefinitionDecorator> getDecoratedHeaders() {
        return this.headers;
    }

    public List<ConnectorTypeDefinitionDecorator> getDecoratedParameters() {
        return this.parameters;
    }
}

