/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine.decorator.operation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.model.parameter.TypeDefinition;
import org.mule.connectivity.templateEngine.decorator.operation.OperationDecorator;
import org.mule.connectivity.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;
import org.mule.connectivity.util.ParserUtils;

public class SmartConnectorOperationDecorator
extends OperationDecorator {
    private final SmartConnectorTypeDefinitionDecorator outputMetadata;
    private final SmartConnectorTypeDefinitionDecorator inputMetadata = this.buildInputMetadata();
    private final List<SmartConnectorTypeDefinitionDecorator> parameters;

    public SmartConnectorOperationDecorator(Operation operation) {
        super(operation);
        this.outputMetadata = this.buildOutputMetadata();
        this.parameters = this.buildDecoratedParameters();
    }

    private List<SmartConnectorTypeDefinitionDecorator> buildDecoratedParameters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameterName : this.getParameters().keySet()) {
            builder.add((Object)new SmartConnectorTypeDefinitionDecorator(parameterName, this.getParameters().get(parameterName)));
        }
        return builder.build();
    }

    private SmartConnectorTypeDefinitionDecorator buildOutputMetadata() {
        if (this.getOutputMetadata() == null) {
            return null;
        }
        SmartConnectorTypeDefinitionDecorator outputMetadata = new SmartConnectorTypeDefinitionDecorator(this.getOutputMetadata());
        outputMetadata.setName(this.getName() + "-response-data");
        outputMetadata.setType(this.getName() + "-response-type");
        return outputMetadata;
    }

    private SmartConnectorTypeDefinitionDecorator buildInputMetadata() {
        if (this.getInputMetadata() == null) {
            return null;
        }
        SmartConnectorTypeDefinitionDecorator inputMetadata = new SmartConnectorTypeDefinitionDecorator(this.getInputMetadata());
        inputMetadata.setName(this.getName() + "-request-data");
        inputMetadata.setType(this.getName() + "-request-type");
        return inputMetadata;
    }

    public String getName() {
        return ParserUtils.getXmlName(this.getCanonicalName());
    }

    public SmartConnectorTypeDefinitionDecorator getDecoratedInputMetadata() {
        return this.inputMetadata;
    }

    public SmartConnectorTypeDefinitionDecorator getDecoratedOutputMetadata() {
        return this.outputMetadata;
    }

    public List<SmartConnectorTypeDefinitionDecorator> getDecoratedParameters() {
        return this.parameters;
    }

    public String getQueryParametersDW() {
        return this.getParametersDW(this.getQueryParameters());
    }

    public String getUriParametersDW() {
        return this.getParametersDW(this.getUriParameters());
    }

    public String getHeadersDW() {
        return this.getParametersDW(this.getHeaders());
    }

    public boolean hasInputParameters() {
        return this.getInputMetadata() != null || !this.getParameters().isEmpty();
    }

    private String getParametersDW(Map<String, TypeDefinition> parameters) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String parameterName : parameters.keySet()) {
            keys.add(String.format("'%s': parameters['%s']", parameterName, ParserUtils.getXmlName(parameterName)));
        }
        return String.format("#[ { %s } filter $ != null ]", StringUtils.join(keys, (String)","));
    }
}

