/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine.decorator.type;

import java.io.IOException;
import java.nio.file.Path;
import org.mule.connectivity.model.parameter.PrimitiveTypeSource;
import org.mule.connectivity.model.parameter.TypeDefinition;
import org.mule.connectivity.templateEngine.decorator.type.TypeDefinitionDecorator;
import org.mule.connectivity.util.FileGenerationUtils;
import org.raml.v2.internal.utils.Inflector;

public class ConnectorTypeDefinitionDecorator
extends TypeDefinitionDecorator {
    private final String basePackage;
    private String fullQualifiedName;
    private String className;

    public ConnectorTypeDefinitionDecorator(String parameterName, TypeDefinition typeDefinition, String basePackage) {
        super(parameterName, typeDefinition);
        this.basePackage = basePackage;
    }

    public ConnectorTypeDefinitionDecorator(TypeDefinition inputMetadata, String basePackage) {
        super(inputMetadata);
        this.basePackage = basePackage;
    }

    public void generatePojo(Path outputDir) throws IOException {
        this.fullQualifiedName = FileGenerationUtils.generatePojo(this.getTypeDefinition().getSource(), this.getClassName(), outputDir.toFile(), this.basePackage);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        if (this.isUnionType()) {
            return "String";
        }
        if (this.isPrimitiveType()) {
            return this.getJavaPrimitiveType();
        }
        if (this.fullQualifiedName != null) {
            return this.fullQualifiedName;
        }
        return this.className;
    }

    private String getJavaPrimitiveType() {
        PrimitiveTypeSource typeSource = (PrimitiveTypeSource)this.getTypeDefinition().getSource();
        switch (typeSource.getType()) {
            case INTEGER: {
                return "Integer";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case NUMBER: {
                return "BigDecimal";
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: {
                return "Date";
            }
            case FILE: {
                return "File";
            }
            case STRING: {
                return "String";
            }
        }
        throw new IllegalArgumentException("Invalid type value: " + typeSource.toString());
    }

    public String getName() {
        return Inflector.lowercamelcase((String)this.getParameterName());
    }

    public boolean requiresPojo() {
        return !this.isPrimitiveType() && !this.isUnionType();
    }
}

