/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.util;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.model.HTTPMethod;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.predicate.OperationNamePredicate;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;
import org.raml.v2.internal.utils.Inflector;

public class ParserUtils {
    private ParserUtils() {
    }

    public static String getMethodDescription(Method method) {
        String description = null;
        if (method.description() != null) {
            description = method.description().value();
        }
        if (method.resource() != null && method.resource().description() != null) {
            description = method.resource().description().value();
        }
        return StringUtils.trimToNull((String)description);
    }

    public static String getMethodDisplayName(Method method) {
        String displayName = null;
        if (!method.displayName().value().equals(method.method())) {
            displayName = method.displayName().value();
        }
        return StringUtils.trimToNull(displayName);
    }

    public static String getCanonicalOperationName(Method method, Operation operation) {
        String annotatedOperationName = ParserUtils.getAnnotatedOperationName(method);
        if (annotatedOperationName != null) {
            return ParserUtils.getCanonicalNameFromFriendlyName(annotatedOperationName);
        }
        if (operation.getFriendlyName() != null) {
            return ParserUtils.getCanonicalNameFromFriendlyName(operation.getFriendlyName());
        }
        return ParserUtils.buildCanonicalOperationName(method);
    }

    private static String buildCanonicalOperationName(Method method) {
        HTTPMethod httpMethod = HTTPMethod.fromMethod(method);
        StringBuilder operationNameBuilder = new StringBuilder().append(httpMethod.getVerbName());
        String resourceName = null;
        Boolean isElement = null;
        ArrayList<String> parameters = new ArrayList<String>();
        String remainingPath = method.resource().resourcePath();
        do {
            String pathSegment = remainingPath.substring(remainingPath.lastIndexOf("/") + 1);
            boolean hasParameter = ParserUtils.hasUriParameter(pathSegment);
            if (isElement == null) {
                isElement = hasParameter;
            }
            if (hasParameter) {
                parameters.add(ParserUtils.getParameterName(pathSegment));
                continue;
            }
            if (resourceName != null) continue;
            resourceName = pathSegment;
        } while (StringUtils.isNotBlank((CharSequence)(remainingPath = remainingPath.substring(0, remainingPath.lastIndexOf("/")))) && !remainingPath.equals("/"));
        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
            resourceName = isElement != false || httpMethod.isAlwaysSingular() ? Inflector.singularize((String)resourceName) : Inflector.pluralize((String)resourceName);
            operationNameBuilder.append("_").append(Inflector.upperunderscorecase((String)resourceName));
        }
        if (!parameters.isEmpty()) {
            Collections.reverse(parameters);
            operationNameBuilder.append("_BY_").append(StringUtils.join(parameters, (String)"_"));
        }
        return operationNameBuilder.toString();
    }

    public static String removeUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9_-]", "");
    }

    public static String removePackageUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9]", "").toLowerCase();
    }

    public static String getXmlName(String name) {
        return Inflector.lowerhyphencase((String)ParserUtils.getXmlSanitizedName(name));
    }

    public static String getXmlSanitizedName(String name) {
        if ((name = ParserUtils.removeUnwantedCharacters(name)).toLowerCase().startsWith("xml") || name.startsWith("-")) {
            name = "-" + name;
        }
        return name;
    }

    public static String getJavaName(String operationName) {
        return Inflector.lowercamelcase((String)ParserUtils.removeUnwantedCharacters(operationName));
    }

    private static String getCanonicalNameFromFriendlyName(String friendlyName) {
        friendlyName = friendlyName.replace(" ", "_");
        return ParserUtils.removeUnwantedCharacters(friendlyName.toUpperCase());
    }

    private static String getParameterName(String uriValue) {
        String cleanParameterName = uriValue.replace("{", "").replace("}", "");
        return Inflector.upperunderscorecase((String)cleanParameterName);
    }

    private static boolean hasUriParameter(String uriValue) {
        return uriValue.matches("\\{.*\\}");
    }

    private static String getAnnotatedOperationName(Method method) {
        AnnotationRef opNameAnnotation = (AnnotationRef)FluentIterable.from((Iterable)Iterables.filter((Iterable)method.annotations(), (Predicate)new OperationNamePredicate())).first().orNull();
        if (opNameAnnotation == null) {
            return null;
        }
        return (String)opNameAnnotation.structuredValue().value();
    }

    public static String getValueFromAnnotableString(AnnotableStringType annotableString) {
        return annotableString == null ? null : annotableString.value();
    }

    public static String removeSpaces(String string) {
        return string == null ? null : string.replace(" ", "");
    }

    public static String removeHyphens(String string) {
        return string == null ? null : string.replace("-", "");
    }

    public static String removeSpacesAndHyphens(String string) {
        return ParserUtils.removeHyphens(ParserUtils.removeSpaces(string));
    }
}

