/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.client.model.domain.FileShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

public class PrimitiveMetadataModelFactory {
    private PrimitiveMetadataModelFactory() {
    }

    public static PrimitiveTypeSource createPrimitiveMetadataModel(Shape shape) {
        if (shape instanceof ScalarShape) {
            String dataType = ((ScalarShape)shape).dataType().value();
            if (ScalarShapeDataType.BOOLEAN.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.BOOLEAN);
            }
            if (ScalarShapeDataType.DATETIME.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.DATE_TIME);
            }
            if (ScalarShapeDataType.DATETIME_ONLY.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.DATE_TIME_ONLY);
            }
            if (ScalarShapeDataType.DATE.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.DATE_ONLY);
            }
            if (ScalarShapeDataType.TIME.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.TIME_ONLY);
            }
            if (ScalarShapeDataType.NUMBER.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.NUMBER);
            }
            if (ScalarShapeDataType.FLOAT.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.NUMBER);
            }
            if (ScalarShapeDataType.DOUBLE.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.NUMBER);
            }
            if (ScalarShapeDataType.INTEGER.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.INTEGER);
            }
            if (ScalarShapeDataType.LONG.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.INTEGER);
            }
            if (ScalarShapeDataType.STRING.equalsIgnoreCase(dataType)) {
                return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.STRING);
            }
        }
        if (shape instanceof FileShape) {
            return new PrimitiveTypeSource(PrimitiveTypeSource.PrimitiveType.FILE);
        }
        throw new IllegalArgumentException("Type declaration isn't from a primitive type.");
    }

    protected static enum ScalarShapeDataType {
        BOOLEAN("http://www.w3.org/2001/XMLSchema#boolean"),
        DATETIME("http://www.w3.org/2001/XMLSchema#dateTime"),
        DATETIME_ONLY("http://a.ml/vocabularies/shapes#dateTimeOnly"),
        DATE("http://www.w3.org/2001/XMLSchema#date"),
        TIME("http://www.w3.org/2001/XMLSchema#time"),
        FLOAT("http://www.w3.org/2001/XMLSchema#float"),
        DOUBLE("http://www.w3.org/2001/XMLSchema#double"),
        NUMBER("http://a.ml/vocabularies/shapes#number"),
        INTEGER("http://www.w3.org/2001/XMLSchema#integer"),
        LONG("http://www.w3.org/2001/XMLSchema#long"),
        STRING("http://www.w3.org/2001/XMLSchema#string");

        private final String schema;

        private ScalarShapeDataType(String schema) {
            this.schema = schema;
        }

        public String toString() {
            return this.schema;
        }

        public boolean equalsIgnoreCase(String value) {
            return this.schema.equalsIgnoreCase(value);
        }
    }
}

