/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader;

import amf.client.remote.Content;
import amf.client.resource.FileResourceLoader;
import amf.client.resource.ResourceLoader;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AMFExchangeDependencyResourceLoader
implements ResourceLoader {
    private File workingDir;
    private final FileResourceLoader resourceLoader = new FileResourceLoader();
    private static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

    public AMFExchangeDependencyResourceLoader(String rootDir) {
        String basePath = rootDir != null ? rootDir : ".";
        this.workingDir = new File(basePath);
    }

    public CompletableFuture<Content> fetch(String path) {
        if (path == null || path.isEmpty()) {
            return this.fail();
        }
        Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path = path.startsWith("file://") ? path.substring(6) : path);
        if (matcher.find()) {
            int dependencyIndex = path.lastIndexOf(matcher.group(0));
            String resourceName = dependencyIndex <= 0 ? path : path.substring(dependencyIndex);
            return this.resourceLoader.fetch(new File(this.workingDir, resourceName).getAbsolutePath());
        }
        return this.fail();
    }

    private CompletableFuture<Content> fail() {
        return CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException("Failed to apply.");
        });
    }
}

