package org.mule.connectivity.restconnect.internal.model.typesource;

import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;

import java.io.StringReader;


public class XmlTypeSource implements TypeSource {

    private String value;
    private String elementName;
    private String schemaPath;

    public XmlTypeSource(String schemaContent) {
        this.value = schemaContent;
        this.elementName = null;
        this.schemaPath = null;
    }

    public XmlTypeSource(String schemaContent, String elementName, String schemaPath) {
        this.value = schemaContent;
        this.elementName = elementName;
        this.schemaPath = schemaPath;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getSchemaPath(){
        return this.schemaPath;
    }

    public String getElementName() {
        if(elementName == null){
            elementName = getDefaultElementName();
        }

        return elementName;
    }

    private String getDefaultElementName(){
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        XmlSchema schema = schemaCol.read(new StringReader(this.value));
        return schema.getElements().keySet().isEmpty() ? null : schema.getElements().keySet().toArray()[0].toString();
    }

}
