package org.mule.connectivity.restconnect.internal.templateEngine.builder;

import org.mule.connectivity.restconnect.internal.templateEngine.DevKitTemplateEngine;

public class DevKitTemplateEngineBuilder extends TemplateEngineBuilder<DevKitTemplateEngineBuilder> {

    private boolean generateProjectFiles = true;

    private DevKitTemplateEngineBuilder() {

    }

    public static DevKitTemplateEngineBuilder createDevKitConnector() {
        return new DevKitTemplateEngineBuilder();
    }

    @Override
    public DevKitTemplateEngineBuilder withGenerateProjectFiles(boolean generateProjectFiles) {
        this.generateProjectFiles = generateProjectFiles;
        return this;
    }

    public boolean getProjectFilesGeneration() {
        return generateProjectFiles;
    }

    @Override
    public void execute() throws Exception {
        DevKitTemplateEngine engine = new DevKitTemplateEngine(this);
        engine.applyTemplates();
    }

    @Override
    public void execute(boolean packageConnector) throws Exception {
        execute();
    }

}
