package org.mule.connectivity.restconnect.internal.templateEngine.builder;

import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;

import java.nio.file.Path;

public abstract class TemplateEngineBuilder<T extends TemplateEngineBuilder> {

    private RestConnectAPIModel model;
    private Path outputDir;

    @SuppressWarnings("unchecked")
    public T fromModel(RestConnectAPIModel model) {
        this.model = model;
        return (T) this;
    }

    @SuppressWarnings("unchecked")
    public T inOutputDir(Path outputDir) {
        this.outputDir = outputDir;
        return (T) this;
    }

    public RestConnectAPIModel getModel() {
        return model;
    }

    public Path getOutputDir() {
        return outputDir;
    }

    public abstract void execute() throws Exception;

    public abstract void execute(boolean packageProject) throws Exception;

    public abstract T withGenerateProjectFiles(boolean generateProjectFiles);

}
