package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model;

import org.mule.connectivity.restconnect.internal.model.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.model.MavenDependency;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUri;

import java.nio.file.Path;
import java.util.List;

public abstract class ModelDecorator {

    protected final RestConnectAPIModel model;

    protected ModelDecorator(RestConnectAPIModel model) {
        this.model = model;
    }

    public String getGroupId() {
        return model.getGroupId();
    }

    public String getArtifactId() {
        return model.getArtifactId();
    }

    public String getVersion() {
        return model.getVersion();
    }

    public String getCustomPackage() { return model.getCustomPackage(); }

    public String getApiName() {
        return model.getApiName();
    }

    public String getApiDescription() {
        return model.getApiDescription();
    }

    public ConnectorCategory getCategory() {
        return model.getCategory();
    }

    public List<Operation> getOperations() {
        return model.getOperations();
    }

    public BaseUri getBaseUri() {
        return model.getBaseUri();
    }

    public List<MavenDependency> getDependencies() {
        return model.getDependencies();
    }

    public Path getRootDir() {
        return model.getRootDir();
    }

    public String getGAV(){
        return getGroupId() + ":" + getArtifactId() + ":" + getVersion();
    }
}
