package org.mule.connectivity.restconnect.internal.modelGeneration.amf.security;

import amf.client.model.domain.OAuth2Flow;
import amf.client.model.domain.OAuth2Settings;

import org.mule.connectivity.restconnect.internal.model.security.naming.OAS2Oauth2Flows;
import org.mule.connectivity.restconnect.internal.model.security.naming.RAMLOauth2Flows;

public class AMFOauth2FlowsNaming {

    public static boolean isAuthorizationCode(OAuth2Settings oAuth2Settings, OAuth2Flow oAuth2Flow){
        if(oAuth2Settings.authorizationGrants().stream().anyMatch(x -> RAMLOauth2Flows.AUTHORIZATION_CODE.equalsIgnoreCase(x.value()))){
            return true;
        }

        return OAS2Oauth2Flows.ACCESS_CODE.equalsIgnoreCase(oAuth2Flow.flow().value());
    }

    public static boolean isClientCredentials(OAuth2Settings oAuth2Settings, OAuth2Flow oAuth2Flow){
        if(oAuth2Settings.authorizationGrants().stream().anyMatch(x -> RAMLOauth2Flows.CLIENT_CREDENTIALS.equalsIgnoreCase(x.value()))){
            return true;
        }

        return OAS2Oauth2Flows.APPLICATION.equalsIgnoreCase(oAuth2Flow.flow().value());
    }
}
