/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.security;

import amf.client.model.StrField;
import amf.client.model.domain.ApiKeySettings;
import amf.client.model.domain.DomainElement;
import amf.client.model.domain.EndPoint;
import amf.client.model.domain.OAuth2Flow;
import amf.client.model.domain.OAuth2Settings;
import amf.client.model.domain.Operation;
import amf.client.model.domain.ParametrizedSecurityScheme;
import amf.client.model.domain.SecurityRequirement;
import amf.client.model.domain.SecurityScheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.model.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.JwtAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.model.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.security.AMFOauth2FlowsNaming;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.security.AMFSecuritySchemesNaming;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil;
import org.mule.connectivity.restconnect.internal.modelGeneration.common.security.SecuritySchemeFactory;

public class AMFSecuritySchemeFactory {
    public static List<APISecurityScheme> getSchemesForOperation(EndPoint endPoint, Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<SecurityScheme> globalSchemes = endPoint.security().stream().flatMap(x -> AMFSecuritySchemeFactory.getSchemes((DomainElement)x)).collect(Collectors.toList());
        List<SecurityScheme> endPointSchemes = endPoint.security().stream().flatMap(x -> AMFSecuritySchemeFactory.getSchemes((DomainElement)x)).collect(Collectors.toList());
        List<SecurityScheme> operationSchemes = operation.security().stream().flatMap(x -> AMFSecuritySchemeFactory.getSchemes((DomainElement)x)).collect(Collectors.toList());
        return AMFSecuritySchemeFactory.getOperationSecuritySchemes(operationSchemes, endPointSchemes, globalSchemes, jsonSchemaPool);
    }

    private static List<APISecurityScheme> getOperationSecuritySchemes(List<SecurityScheme> operationSchemes, List<SecurityScheme> endPointSchemes, List<SecurityScheme> globalSchemes, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<SecurityScheme> securitySchemesForOperation = SecuritySchemeFactory.getSecuritySchemesForOperation(operationSchemes, endPointSchemes, globalSchemes);
        if (!securitySchemesForOperation.isEmpty()) {
            return AMFSecuritySchemeFactory.getAPISecuritySchemes(securitySchemesForOperation, jsonSchemaPool);
        }
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        returnSchemes.add(new UnsecuredScheme());
        return returnSchemes;
    }

    private static List<APISecurityScheme> getAPISecuritySchemes(List<SecurityScheme> sourceSchemes, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        LinkedList<APISecurityScheme> returnSchemes = new LinkedList<APISecurityScheme>();
        for (SecurityScheme scheme : sourceSchemes) {
            List<APISecurityScheme> generatedSchemes = AMFSecuritySchemeFactory.createSecuritySchemes(scheme, jsonSchemaPool);
            for (APISecurityScheme generatedScheme : generatedSchemes) {
                if (!returnSchemes.stream().noneMatch(x -> x.equals(generatedScheme))) continue;
                returnSchemes.add(generatedScheme);
            }
        }
        if (!sourceSchemes.isEmpty() && returnSchemes.isEmpty()) {
            throw new UnsupportedSecuritySchemeException("None of the specified security schemes ( " + AMFSecuritySchemeFactory.listSchemes(sourceSchemes) + ") are supported.");
        }
        return returnSchemes;
    }

    private static List<APISecurityScheme> createSecuritySchemes(SecurityScheme scheme, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        ArrayList<APISecurityScheme> apiSecuritySchemes = new ArrayList<APISecurityScheme>();
        if (scheme == null || !scheme.type().nonEmpty()) {
            apiSecuritySchemes.add(new UnsecuredScheme());
            return apiSecuritySchemes;
        }
        String schemeType = scheme.type().value();
        if (AMFSecuritySchemesNaming.isBasicAuth(schemeType)) {
            apiSecuritySchemes.add(new BasicAuthScheme());
        } else if (AMFSecuritySchemesNaming.isPassThrough(schemeType)) {
            apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildPassThroughSecurityScheme(scheme, jsonSchemaPool));
        } else if (AMFSecuritySchemesNaming.isApiKey(schemeType)) {
            apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildApiKeySecurityScheme(scheme, jsonSchemaPool));
        } else if (AMFSecuritySchemesNaming.isOauth2(schemeType)) {
            OAuth2Settings oAuth2Settings = (OAuth2Settings)scheme.settings();
            OAuth2Flow oAuth2Flow = oAuth2Settings.flows().stream().filter(x -> AMFOauth2FlowsNaming.isAuthorizationCode(oAuth2Settings, x) || AMFOauth2FlowsNaming.isClientCredentials(oAuth2Settings, x)).findFirst().orElse(null);
            if (oAuth2Flow != null) {
                if (AMFOauth2FlowsNaming.isAuthorizationCode(oAuth2Settings, oAuth2Flow)) {
                    apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildOAuth2AuthorizationCodeSecurityScheme(scheme, oAuth2Flow));
                } else if (AMFOauth2FlowsNaming.isClientCredentials(oAuth2Settings, oAuth2Flow)) {
                    apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildOAuth2ClientCredentialsSecurityScheme(scheme, oAuth2Flow));
                }
            }
        } else if (AMFSecuritySchemesNaming.isDigestAuth(schemeType)) {
            apiSecuritySchemes.add(new DigestAuthenticationScheme());
        } else if (AMFSecuritySchemesNaming.isJwtAuth(schemeType)) {
            apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildJwtAuthenticationScheme(scheme, jsonSchemaPool));
        } else if (AMFSecuritySchemesNaming.isCustom(schemeType)) {
            apiSecuritySchemes.add(AMFSecuritySchemeFactory.buildCustomAuthenticationScheme(scheme, jsonSchemaPool));
        }
        return apiSecuritySchemes;
    }

    private static Stream<SecurityScheme> getSchemes(DomainElement domainElement) {
        if (domainElement instanceof SecurityRequirement) {
            SecurityRequirement securityRequirement = (SecurityRequirement)domainElement;
            return securityRequirement.schemes().stream().map(ParametrizedSecurityScheme::scheme);
        }
        return Stream.empty();
    }

    private static PassThroughScheme buildPassThroughSecurityScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<Parameter> queryParameters = AMFParserUtil.getParameterList(securityScheme.queryParameters(), ParameterType.SECURITY, jsonSchemaPool);
        List<Parameter> headers = AMFParserUtil.getParameterList(securityScheme.headers(), ParameterType.SECURITY, jsonSchemaPool);
        return new PassThroughScheme(queryParameters, headers);
    }

    private static PassThroughScheme buildApiKeySecurityScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<Parameter> queryParameters = AMFParserUtil.getParameterList(securityScheme.queryParameters(), ParameterType.SECURITY, jsonSchemaPool);
        List<Parameter> headers = AMFParserUtil.getParameterList(securityScheme.headers(), ParameterType.SECURITY, jsonSchemaPool);
        if (securityScheme.settings() instanceof ApiKeySettings) {
            String in = ((ApiKeySettings)securityScheme.settings()).in().value();
            String name = ((ApiKeySettings)securityScheme.settings()).name().value();
            if (in.equalsIgnoreCase("query")) {
                queryParameters.add(new Parameter(name, ParameterType.SECURITY, TypeDefinitionBuilder.buildSimpleStringType(true)));
            } else {
                headers.add(new Parameter(name, ParameterType.SECURITY, TypeDefinitionBuilder.buildSimpleStringType(true)));
            }
        }
        return new PassThroughScheme(queryParameters, headers);
    }

    private static JwtAuthenticationScheme buildJwtAuthenticationScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<Parameter> queryParameters = AMFParserUtil.getParameterList(securityScheme.queryParameters(), ParameterType.SECURITY, jsonSchemaPool);
        List<Parameter> headers = AMFParserUtil.getParameterList(securityScheme.headers(), ParameterType.SECURITY, jsonSchemaPool);
        LinkedList<Parameter> body = new LinkedList<Parameter>();
        body.addAll(queryParameters);
        body.addAll(headers);
        return new JwtAuthenticationScheme(headers, body, queryParameters);
    }

    private static CustomAuthenticationScheme buildCustomAuthenticationScheme(SecurityScheme securityScheme, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        List<Parameter> queryParameters = AMFParserUtil.getParameterList(securityScheme.queryParameters(), ParameterType.SECURITY, jsonSchemaPool);
        List<Parameter> headers = AMFParserUtil.getParameterList(securityScheme.headers(), ParameterType.SECURITY, jsonSchemaPool);
        return new CustomAuthenticationScheme(queryParameters, headers);
    }

    private static OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeSecurityScheme(SecurityScheme securityScheme, OAuth2Flow oAuth2Flow) {
        List<String> authorizationGrants = Collections.singletonList("authorization_code");
        List<String> scopes = oAuth2Flow.scopes().stream().map(s -> s.name().value()).collect(Collectors.toList());
        String renewTokenExpression = AMFParserUtil.getAnnotatedRenewTokenExpression(securityScheme);
        return new OAuth2AuthorizationCodeScheme(oAuth2Flow.authorizationUri().value(), oAuth2Flow.accessTokenUri().value(), authorizationGrants, scopes, renewTokenExpression);
    }

    private static OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsSecurityScheme(SecurityScheme securityScheme, OAuth2Flow oAuth2Flow) {
        List<String> authorizationGrants = Collections.singletonList("client_credentials");
        List<String> scopes = oAuth2Flow.scopes().stream().map(s -> s.name().value()).collect(Collectors.toList());
        String renewTokenExpression = AMFParserUtil.getAnnotatedRenewTokenExpression(securityScheme);
        return new OAuth2ClientCredentialsScheme(oAuth2Flow.authorizationUri().value(), oAuth2Flow.accessTokenUri().value(), authorizationGrants, scopes, renewTokenExpression);
    }

    private static String listSchemes(List<SecurityScheme> securitySchemes) {
        StringBuilder builder = new StringBuilder();
        for (SecurityScheme securityScheme : securitySchemes) {
            builder.append(securityScheme.name());
            builder.append(":");
            builder.append(securityScheme.type().value());
            if (securityScheme.type().value().equals("OAuth 2.0") && securityScheme.settings() != null) {
                OAuth2Settings settings = (OAuth2Settings)securityScheme.settings();
                builder.append(" :");
                if (settings.authorizationGrants() != null && settings.authorizationGrants().size() > 0) {
                    for (StrField grant : settings.authorizationGrants()) {
                        builder.append(" ");
                        builder.append(grant.value());
                    }
                }
            }
            builder.append(". ");
        }
        return builder.toString();
    }
}

