package org.mule.connectivity.restconnect.internal.model.security;

import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class OAuth2AuthorizationCodeScheme extends OAuth2Scheme {

    public OAuth2AuthorizationCodeScheme(String authorizationUri, String accessTokenUri, List<String> grants, List<String> scopes) {
        super(authorizationUri, accessTokenUri, grants, scopes);
    }

    @Override
    public void initializeConfigParameters() {
        configParameters = new LinkedList<>();

        configParameters.addAll(Arrays.asList(
                getSecuritySchemeParameter("clientId", "clientId", PrimitiveTypeSource.PrimitiveType.STRING, "OAuth2 Client Id", null, null, true,false),
                getSecuritySchemeParameter("clientSecret", "clientSecret", PrimitiveTypeSource.PrimitiveType.STRING, "OAuth2 Client Secret", null, null, true,true),
                getSecuritySchemeParameter("localCallbackPath", "localCallbackPath", PrimitiveTypeSource.PrimitiveType.STRING, "Path for autogenerating the local callback endpoint", "/callback", "/callback", true,false),
                getSecuritySchemeParameter("localCallbackConfig", "localCallbackConfig", PrimitiveTypeSource.PrimitiveType.STRING, "HTTP Listener Configuration name for exposing the callback endpoint", "cloudhub_http", "cloudhub_http", true,false),
                getSecuritySchemeParameter("externalCallbackUrl", "externalCallbackUrl", PrimitiveTypeSource.PrimitiveType.STRING, "URL for redirecting after the OAuth dance login", "http://my-app.cloudhub.io/callback", "http://my-app.cloudhub.io/callback", true,false),
                getSecuritySchemeParameter("localAuthorizationUrl", "localAuthorizationUrl", PrimitiveTypeSource.PrimitiveType.STRING, "Local URL for autogenerating the endpoint that starts the OAuth dance", "http://localhost:8081/authorize", "http://localhost:8081/authorize", true,false),
                getSecuritySchemeParameter("authorizationUrl", "authorizationUrl", PrimitiveTypeSource.PrimitiveType.STRING, "Authorize URL for consuming API", getAuthorizationUri(), getAuthorizationUri(), true,false),
                getSecuritySchemeParameter("accessTokenUrl", "accessTokenUrl", PrimitiveTypeSource.PrimitiveType.STRING, "Token URL for consuming API", getAccessTokenUri(), getAccessTokenUri(), true,false)
        ));

        addScopeConfigParameter();
    }
}
