package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import amf.client.model.domain.EndPoint;
import amf.client.model.domain.WebApi;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.operation.OperationBuilder;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;

import java.util.ArrayList;
import java.util.List;

import static org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFTypeDefinitionFactory.buildInputMetadata;
import static org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFTypeDefinitionFactory.buildOutputMetadata;
import static org.mule.connectivity.restconnect.internal.modelGeneration.amf.security.AMFSecuritySchemeFactory.getSchemesForOperation;
import static org.mule.connectivity.restconnect.internal.modelGeneration.amf.util.AMFParserUtil.*;

public class AMFOperationGenerator {

    public static Operation generateOperation(WebApi api, EndPoint endPoint, amf.client.model.domain.Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {

        String friendlyName = getMethodDisplayName(operation);

        return new OperationBuilder()
                .withFriendlyName(friendlyName)
                .withAnnotatedDisplayName(getAnnotatedOperationName(operation))
                .withCanonicalName(getCanonicalOperationName(endPoint, operation, friendlyName))
                .withDescription(buildOperationDescription(endPoint, operation))
                .withHttpMethod(HTTPMethod.fromString(operation.method().value()))
                .withUri(endPoint.path().value())
                .withUriParams(buildUriParams(endPoint, jsonSchemaPool))
                .withQueryParams(buildQueryParams(operation, jsonSchemaPool))
                .withHeaders(buildHeaders(operation, jsonSchemaPool))
                .withInputMetadata(buildInputMetadata(operation, jsonSchemaPool))
                .withOutputMetadata(buildOutputMetadata(operation, jsonSchemaPool))
                .withSecuritySchemes(getSchemesForOperation(endPoint, operation, jsonSchemaPool))
                .withUserSelectedSecuritySchemes(isUserSelectedSecuritySchemes(endPoint, operation, api))
                .build();
    }

    private static String buildOperationDescription(EndPoint endPoint, amf.client.model.domain.Operation operation) {
        return operation.description().nonEmpty() ? operation.description().value() : endPoint.description().value();
    }

    private static List<Parameter> buildUriParams(EndPoint endPoint, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        return getParameterList(endPoint.parameters(), ParameterType.URI, jsonSchemaPool);
    }

    private static List<Parameter> buildQueryParams(amf.client.model.domain.Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        if(operation.request() != null){
            return getParameterList(operation.request().queryParameters(), ParameterType.QUERY, jsonSchemaPool);
        }
        return new ArrayList<>();
    }

    private static List<Parameter> buildHeaders(amf.client.model.domain.Operation operation, JsonSchemaPool jsonSchemaPool) throws GenerationException {
        if(operation.request() != null){
            return getParameterList(operation.request().headers(), ParameterType.HEADER, jsonSchemaPool);
        }
        return new ArrayList<>();
    }

}
