package org.mule.connectivity.restconnect.internal.templateEngine;

import org.apache.velocity.VelocityContext;
import org.apache.velocity.tools.ToolManager;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.templateEngine.builder.SdkConnectorTemplateEngineBuilder;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ConfigurationUtil;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.file.Path;

import static java.lang.String.format;


public class SdkConnectorTemplateEngine extends TemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger(SdkConnectorTemplateEngine.class);
    private static ToolManager velocityToolManager;

    static {
        velocityToolManager = new ToolManager();
        velocityToolManager.configure("velocity-tools.xml");
    }

    private final RestConnectAPIModel model;
    private final Path outputDir;

    public SdkConnectorTemplateEngine(SdkConnectorTemplateEngineBuilder builder) {
        this.model = builder.getModel();
        this.outputDir = builder.getOutputDir();
    }

    @Override
    public void applyTemplates() throws Exception {
        new Extension(model, outputDir.resolve(format("generated-sources/%s",
                ConfigurationUtil.buildBasePackage(model, ConfigurationUtil.buildApiName(model)).replaceAll("\\.|_", "/"))),
                outputDir.resolve("generated-resources"),
                new VelocityContext(velocityToolManager.createContext()))
                .generate();
    }
}
