package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;
import org.mule.connectivity.restconnect.internal.util.JavaRequestUtils;
import org.mule.connectivity.restconnect.internal.util.TemplateUtils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;

public abstract class ExtensionEntity {
    private final VelocityContext context;
    private final Path sourcesPath;
    private final Path resourcesPath;

    public ExtensionEntity(Path sourcesPath, Path resourcesPath, VelocityContext context) {
        this.context = context;
        this.sourcesPath = sourcesPath;
        this.resourcesPath = resourcesPath;
    }

    public abstract void generate();

    protected Path getResourcesPath() {
        return resourcesPath;
    }

    protected void applyTemplate(String template, String relativePath) {
        context.put(getClass().getSimpleName().toLowerCase(), this);
        context.put("StringUtils", StringUtils.class);
        context.put("DataWeaveUtils", DataWeaveUtils.class);
        context.put("JavaRequestUtils", JavaRequestUtils.class);
        context.put("TemplateUtils", TemplateUtils.class);

        VelocityEngine engine = new VelocityEngine();
        engine.setProperty(RuntimeConstants.RESOURCE_LOADER, "classpath");
        engine.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        engine.init();

        File targetFile = sourcesPath.resolve(relativePath).toFile();
        targetFile.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile))) {
            engine.getTemplate(template, "UTF-8").merge(context, writer);
        } catch (IOException e) {
            // TODO: Handle exception properly.
            throw new RuntimeException(e);
        }
    }
}
