package org.mule.connectivity.restconnect.internal.util;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.DevKitOperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.DevKitConnectorTypeDefinitionDecorator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class JavaRequestUtils {

    public static String buildRequestEntity(DevKitOperationDecorator operation) throws IOException {

        DevKitConnectorTypeDefinitionDecorator type = operation.getDecoratedInputMetadata();

        StringBuilder builder = new StringBuilder();

        if(type.getTypeDefinition().getSource() instanceof MultipartTypeSource){
            MultipartTypeSource source = (MultipartTypeSource)type.getTypeDefinition().getSource();

            builder.append("MultiPart multiPart = new MultiPart(MediaType.MULTIPART_FORM_DATA_TYPE);").append(System.lineSeparator());

            int partCount = 0;
            for(PartParameter part : source.getParts()){

                String getterMethod = getGetterMethodForAttribute(type, part.getExternalName());
                if(getterMethod != null){
                    partCount++;

                    String partName = getPartName(part);
                    String mediaType = getPartMediaType(part);
                    String filename = getPartFilename(part);

                    builder.append(System.lineSeparator());
                    builder.append("FormDataBodyPart bodyPart").append(partCount).append(" = new FormDataBodyPart(")
                            .append(partName).append(", entity.").append(getterMethod).append("(), ")
                            .append("MediaType.valueOf(\"").append(mediaType).append("\"));");

                    builder.append("bodyPart").append(partCount);

                    builder.append(".setContentDisposition(FormDataContentDisposition.name(").append(partName).append(")");

                    if(StringUtils.isNotBlank(filename)){
                        builder.append(".fileName(").append(filename).append(")");
                    }

                    builder.append(".build());").append(System.lineSeparator());
                }
                else{
                    System.out.println("Could not find a getter method for property: " + part.getExternalName());
                }
            }

            if(partCount > 0){
                builder.append(System.lineSeparator()).append("multiPart");

                for(int i = 1; i <= partCount; i++){
                    builder.append(".bodyPart(bodyPart").append(i).append(")");
                }

                builder.append(";").append(System.lineSeparator());
            }

            builder.append("requestBuilder.entity(multiPart);").append(System.lineSeparator());
        }
        else {
            builder.append("requestBuilder.entity(entity);").append(System.lineSeparator());
        }

        return builder.toString();
    }

    private static String getPartName(PartParameter partParameter){
        if(partParameter.getPartNameParameter() != null){
            return partParameter.getPartNameParameter().getInternalName();
        }

        if(StringUtils.isNotBlank(partParameter.getPartName())){
            return "\"" + partParameter.getPartName() + "\"";
        }

        return "\"" + partParameter.getExternalName() + "\"";
    }

    private static String getPartMediaType(PartParameter partParameter){
        if(StringUtils.isNotBlank(partParameter.getPartContentType())){
            return partParameter.getPartContentType();
        }

        return partParameter.getTypeDefinition().getMediaType().toString();
    }

    private static String getPartFilename(PartParameter partParameter){
        if(partParameter.getPartFilenameParameter() != null){
            return partParameter.getPartFilenameParameter().getInternalName();
        }

        if(StringUtils.isNotBlank(partParameter.getPartFilename())){
            return "\"" + partParameter.getPartFilename() + "\"";
        }

        return null;
    }

    private static String getGetterMethodForAttribute(DevKitConnectorTypeDefinitionDecorator type, String attributeName) throws IOException {
        InputStream stream = new FileInputStream(type.getPojoLocation().toFile());

        CompilationUnit cu;

        try{
            cu = JavaParser.parse(stream);
        }
        finally {
            stream.close();
        }

        Optional<MethodDeclaration> getter = cu.findAll(MethodDeclaration.class).stream()
                .filter(f -> f.isPublic() && !f.isStatic())
                .filter(f -> f.getName().asString().toLowerCase().startsWith("get") && f.getName().asString().toLowerCase().contains(attributeName.toLowerCase()))
                .findFirst();

        return getter.isPresent() ? getter.get().getName().asString() : null;
    }
}
