package org.mule.connectivity.restconnect.mojo;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.RestConnect;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;

import static org.mule.connectivity.restconnect.internal.util.MojoUtils.getMainRamlFile;


@Mojo(name = "raml2sdkconnector", defaultPhase = LifecyclePhase.GENERATE_SOURCES, requiresProject = false)
public class Raml2SdkConnectorMojo extends AbstractMojo {

    private Logger logger = LoggerFactory.getLogger(Raml2ConnectorMojo.class);

    @Parameter(property = "raml", required = true)
    private String raml;

    @Parameter(property = "name")
    private String name;

    @Parameter(property = "packageConnector", defaultValue = "true")
    private boolean packageConnector;

    @Parameter(property = "outputDir", defaultValue = "target")
    private File outputDir;

    @Parameter(property = "specFormat", defaultValue = "raml")
    private String specFormat;

    @Parameter(property = "parser", defaultValue = "AMF")
    private String parser;

    public void execute() throws MojoExecutionException {
        try {
            RestConnect.getInstance()
                    .createConnectorFromSpec(getMainRamlFile(raml), SpecFormat.getFromString(specFormat), Parser.getFromString(parser), ConnectorType.SdkConnector)
                    .withApiName(name)
                    .withOutputDir(outputDir.toPath())
                    .withPackageConnector(packageConnector)
                    .run();
        } catch (Exception e) {
            logger.error("Failed to build connector.", e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }
}