/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import com.google.common.base.CaseFormat;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.Parameter;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;

public class Content
extends Parameter {
    private final String schemaFile;
    private final String schemaType;

    public Content(String name, TypeDefinition typeDefinition, Path outputDir, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(name, typeDefinition, sourcesPath, resourcesPath, context);
        this.schemaFile = FileGenerationUtils.writeSchema(typeDefinition.getSource(), String.format("%s-schema", name), outputDir);
        this.schemaType = Optional.ofNullable(this.schemaFile).map(value -> CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, value.substring(value.lastIndexOf(".") + 1))).orElse(null);
    }

    public String getSchemaFile() {
        return this.schemaFile;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String getQname() {
        return null;
    }

    @Override
    public String getType() {
        return "InputStream";
    }

    @Override
    public String getName() {
        return String.format("%sBody", super.getName());
    }
}

