/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import com.google.common.base.CaseFormat;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.Config;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ConfigurationUtil;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ErrorType;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ExtensionEntity;

public class Extension
extends ExtensionEntity {
    private final String name;
    private final String category;
    private final List<Config> configs;
    private final String basePackage;
    private final String xml;
    private final String testUrl;
    private final List<ErrorType> errorTypes;

    public Extension(RestConnectAPIModel model, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        this.name = ConfigurationUtil.buildApiName(model);
        this.category = Optional.ofNullable(model.getCategory()).map(Enum::name).orElse(null);
        this.basePackage = ConfigurationUtil.buildBasePackage(model, this.name);
        this.xml = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name).replace("_", "-");
        this.testUrl = null;
        this.errorTypes = new ArrayList<ErrorType>();
        this.configs = Stream.of(new Config(model, sourcesPath, resourcesPath, context)).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getXml() {
        return this.xml;
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public List<ErrorType> getErrorTypes() {
        return this.errorTypes;
    }

    public List<Config> getConfigs() {
        return this.configs;
    }

    @Override
    public void generate() {
        this.applyTemplate("templates/sdk/extension/Extension.vm", String.format("internal/extension/%sExtension.java", this.name));
        this.applyTemplate("templates/sdk/connection/Connection.vm", String.format("internal/connection/%sConnection.java", this.name));
        this.applyTemplate("templates/sdk/error/ErrorTypes.vm", String.format("internal/error/%sErrorTypes.java", this.name));
        this.applyTemplate("templates/sdk/error/ErrorTypeProvider.vm", String.format("internal/error/%sErrorTypeProvider.java", this.name));
        this.configs.forEach(Config::generate);
    }
}

