/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import com.google.common.base.CaseFormat;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.Content;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ExtensionEntity;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.Parameter;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;

public class Operation
extends ExtensionEntity {
    private final String name;
    private final String httpMethod;
    private final String relativePath;
    private final String summary;
    private final String lowerCaseName;
    private final List<Parameter> pathParameters;
    private final List<Parameter> queryParameters;
    private final List<Parameter> headers;
    private final Content content;
    private String resultSchemaFile;
    private String resultSchemaType;

    public Operation(org.mule.connectivity.restconnect.internal.model.operation.Operation model, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        Function<org.mule.connectivity.restconnect.internal.model.parameter.Parameter, Parameter> parameterAdapter = parameter -> new Parameter(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, parameter.getInternalName().replace("-", "_")), parameter.getTypeDefinition(), sourcesPath, resourcesPath, context);
        this.name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, model.getCanonicalName());
        this.lowerCaseName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, model.getCanonicalName());
        this.httpMethod = model.getHttpMethod().toLowerCase();
        this.relativePath = model.getUri();
        this.summary = Optional.ofNullable(model.getDescription()).map(value -> value.replace("\"", "\\\"").replace("\n", "\\n")).orElse(null);
        this.pathParameters = model.getUriParameters().stream().map(parameterAdapter).collect(Collectors.toList());
        this.queryParameters = model.getQueryParameters().stream().map(parameterAdapter).collect(Collectors.toList());
        this.headers = model.getHeaders().stream().map(parameterAdapter).collect(Collectors.toList());
        this.content = Optional.ofNullable(model.getInputMetadata()).map(typeDefinition -> new Content(this.lowerCaseName, (TypeDefinition)typeDefinition, resourcesPath, sourcesPath, resourcesPath, context)).orElse(null);
        if (model.getOutputMetadata() != null && !(model.getOutputMetadata().getSource() instanceof PrimitiveTypeSource)) {
            this.resultSchemaFile = Optional.ofNullable(model.getOutputMetadata()).map(TypeDefinition::getSource).map(source -> FileGenerationUtils.writeSchema(source, String.format("%s-schema", this.name), resourcesPath)).orElse(null);
            this.resultSchemaType = Optional.ofNullable(this.resultSchemaFile).map(value -> CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value.substring(value.lastIndexOf(".") + 1))).orElse(null);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getLowerCaseName() {
        return this.lowerCaseName;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public List<Parameter> getPathParameters() {
        return this.pathParameters;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public Content getContent() {
        return this.content;
    }

    public String getResultSchemaFile() {
        return this.resultSchemaFile;
    }

    public String getResultSchemaType() {
        return this.resultSchemaType;
    }

    public List<Parameter> getParameters() {
        return Stream.concat(Stream.concat(this.pathParameters.stream(), this.queryParameters.stream()), Stream.concat(this.headers.stream(), Optional.ofNullable(this.content).map(Stream::of).orElseGet(() -> Stream.of(new Content[0])))).collect(Collectors.toList());
    }

    @Override
    public void generate() {
        this.applyTemplate("templates/sdk/operation/Operation.vm", String.format("internal/operation/%sOperation.java", this.name));
    }
}

