/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk;

import com.google.common.base.CaseFormat;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.velocity.VelocityContext;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.sdk.ExtensionEntity;
import org.mule.connectivity.restconnect.internal.util.TemplateUtils;

public class Parameter
extends ExtensionEntity {
    private final String name;
    private final String type;
    private final String summary;
    private final boolean optional;
    private final String defaultValue;
    private final List<String> allowedValues;
    private final String displayName;

    public Parameter(String name, TypeDefinition typeDefinition, Path sourcesPath, Path resourcesPath, VelocityContext context) {
        super(sourcesPath, resourcesPath, context);
        this.name = name;
        this.displayName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, Optional.ofNullable(typeDefinition.getAnnotatedDisplayName()).orElse(name));
        this.type = typeDefinition.isArrayType() ? "List<String>" : "String";
        this.summary = Optional.ofNullable(typeDefinition.getDescription()).map(value -> value.replace("\"", "\\\"").replace("\n", "\\n")).orElse(null);
        this.optional = !typeDefinition.isRequired();
        this.defaultValue = typeDefinition.getDefaultValue();
        this.allowedValues = typeDefinition.getEnumValues();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public void generate() {
        Optional.ofNullable(this.allowedValues).filter(list -> list.size() > 1).ifPresent(values -> this.applyTemplate("templates/sdk/metadata/FixedValuesValueProvider.vm", String.format("internal/metadata/%sValueProvider.java", TemplateUtils.toUpperCamel(this.name))));
    }
}

