/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.SmartConnectorSecuritySchemeHelper;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.OperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecoratorFactory;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;

public class SdkConnectorOperationDecorator
extends OperationDecorator {
    private final SmartConnectorTypeDefinitionDecorator outputMetadata;
    private final SmartConnectorTypeDefinitionDecorator inputMetadata;
    private final List<SmartConnectorTypeDefinitionDecorator> parameters;
    private final SmartConnectorSecuritySchemeDecorator prioritarySecuritySchemeDecorator;
    private final List<SmartConnectorSecuritySchemeDecorator> allSecuritySchemesDecorators;
    private String allSecuritySchemesFilename;

    public SdkConnectorOperationDecorator(Operation operation, HashMap<APISecurityScheme, String> securitySchemesNames) {
        super(operation);
        if (operation.getInputMetadata() == null) {
            this.inputMetadata = null;
        } else {
            SmartConnectorTypeDefinitionDecorator inputMetadata = new SmartConnectorTypeDefinitionDecorator(operation.getInputMetadata());
            inputMetadata.setName(this.getName() + "-request-data");
            inputMetadata.setType(this.getName() + "-request-type");
            this.inputMetadata = inputMetadata;
        }
        if (operation.getOutputMetadata() == null) {
            this.outputMetadata = null;
        } else {
            SmartConnectorTypeDefinitionDecorator outputMetadata = new SmartConnectorTypeDefinitionDecorator(operation.getOutputMetadata());
            outputMetadata.setName(this.getName() + "-response-data");
            outputMetadata.setType(this.getName() + "-response-type");
            this.outputMetadata = outputMetadata;
        }
        this.parameters = SdkConnectorOperationDecorator.buildDecoratedParameters(operation.getParameters(), "");
        if (operation.isUserSelectedSecuritySchemes() && operation.getSecuritySchemes().size() > 1) {
            this.allSecuritySchemesDecorators = operation.getSecuritySchemes().stream().map(x -> SmartConnectorSecuritySchemeDecoratorFactory.getSecuritySchemeDecorator(x, securitySchemesNames)).collect(Collectors.toList());
            this.prioritarySecuritySchemeDecorator = null;
        } else {
            this.prioritarySecuritySchemeDecorator = SmartConnectorSecuritySchemeDecoratorFactory.getSecuritySchemeDecorator(SmartConnectorSecuritySchemeHelper.getPrioritarySecurityScheme(operation.getSecuritySchemes()), securitySchemesNames);
            this.allSecuritySchemesDecorators = null;
        }
    }

    public static List<SmartConnectorTypeDefinitionDecorator> buildDecoratedParameters(List<Parameter> parameters, String namePrefix) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter param : parameters) {
            builder.add((Object)new SmartConnectorTypeDefinitionDecorator((!namePrefix.isEmpty() ? namePrefix + "-" : "") + param.getExternalName(), (!namePrefix.isEmpty() ? namePrefix + "-" : "") + param.getInternalName(), param.getTypeDefinition(), param.isPassword()));
        }
        return builder.build();
    }

    @Override
    public List<Parameter> getHeaders() {
        List<Parameter> baseHeaders = super.getHeaders();
        if (!baseHeaders.stream().map(Parameter::getExternalName).anyMatch("accept"::equalsIgnoreCase) && this.outputMetadata != null && this.outputMetadata.hasMediaType()) {
            LinkedList<Parameter> headers = new LinkedList<Parameter>();
            Parameter fixedValueHeader = new Parameter("Accept", ParameterType.HEADER, TypeDefinitionBuilder.buildHeaderType());
            fixedValueHeader.setFixedValue(this.outputMetadata.getMediaType());
            headers.add(fixedValueHeader);
            headers.addAll(baseHeaders);
            return headers;
        }
        return baseHeaders;
    }

    public String getName() {
        return ParserUtils.getXmlName(this.getCanonicalName());
    }

    public SmartConnectorTypeDefinitionDecorator getDecoratedInputMetadata() {
        return this.inputMetadata;
    }

    public SmartConnectorTypeDefinitionDecorator getDecoratedOutputMetadata() {
        return this.outputMetadata;
    }

    public List<SmartConnectorTypeDefinitionDecorator> getDecoratedParameters() {
        return this.parameters;
    }

    public String getQueryParametersDW() {
        return DataWeaveUtils.getParametersDW(this.getQueryParameters(), null);
    }

    public String getUriParametersDW() {
        return DataWeaveUtils.getParametersDW(this.getUriParameters(), null);
    }

    public String getHeadersDW() {
        return DataWeaveUtils.getParametersDW(this.getHeaders(), null);
    }

    public boolean hasInputParameters() {
        return this.getInputMetadata() != null || !this.getParameters().isEmpty();
    }

    public SmartConnectorSecuritySchemeDecorator getSecurityScheme() {
        return this.prioritarySecuritySchemeDecorator;
    }

    public List<SmartConnectorSecuritySchemeDecorator> getAllSecuritySchemes() {
        return this.allSecuritySchemesDecorators;
    }

    private List<String> getAllSecuritySchemesNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (SmartConnectorSecuritySchemeDecorator ss : this.getAllSecuritySchemes()) {
            names.add(ss.getFriendlyName());
        }
        return names;
    }

    public String getAllSecuritySchemesNamesEnum() {
        return "\"" + String.join((CharSequence)"\",\"", this.getAllSecuritySchemesNames()) + "\"";
    }

    public String getAllSecuritySchemesFilename() {
        return this.allSecuritySchemesFilename;
    }

    public void setAllSecuritySchemesFilename(String allSecuritySchemesFilename) {
        this.allSecuritySchemesFilename = allSecuritySchemesFilename;
    }
}

