/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit;

import java.util.Map;
import java.util.Optional;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;

public abstract class DevKitSecuritySchemeDecorator {
    private APISecurityScheme apiSecurityScheme;
    private final String configName;
    private String configNameSufix = "";

    public DevKitSecuritySchemeDecorator(APISecurityScheme securityScheme, Map<APISecurityScheme, String> securitySchemesNames) {
        this.apiSecurityScheme = securityScheme;
        this.configName = this.buildConfigName(securityScheme, securitySchemesNames);
    }

    private String buildConfigName(APISecurityScheme securityScheme, Map<APISecurityScheme, String> securitySchemesNames) {
        String configName;
        Optional<APISecurityScheme> existingScheme;
        if (securitySchemesNames.isEmpty()) {
            securitySchemesNames.put(securityScheme, this.getDefaultConfigName());
        }
        if ((existingScheme = securitySchemesNames.keySet().stream().filter(x -> x.equals(securityScheme)).findFirst()).isPresent()) {
            return securitySchemesNames.get(existingScheme.get());
        }
        String nameCandidate = configName = this.getDefaultConfigName();
        Integer i = 2;
        while (securitySchemesNames.containsValue(nameCandidate)) {
            this.configNameSufix = i.toString();
            nameCandidate = configName + this.configNameSufix;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        securitySchemesNames.put(securityScheme, nameCandidate);
        return nameCandidate;
    }

    public APISecurityScheme getApiSecurityScheme() {
        return this.apiSecurityScheme;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigNameSufix() {
        return this.configNameSufix;
    }

    public abstract String getTemplateLocation();

    public abstract String getDefaultConfigName();
}

