package org.mule.connectivity.restconnect.internal.model.type;

import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;

import javax.ws.rs.core.MediaType;
import java.util.List;

public class TypeDefinition {

    private MediaType mediaType;
    private TypeSource source;
    private boolean required;
    private String description;
    private boolean unionType;
    private boolean arrayType;
    private String defaultValue;
    private String example;
    private String annotatedDisplayName;
    private List<String> enumValues;

    protected TypeDefinition(){

    }

    public MediaType getMediaType() {
        return mediaType;
    }

    public TypeSource getSource() {
        return source;
    }

    public boolean isRequired() {
        return required;
    }

    public boolean isUnionType() {
        return unionType;
    }

    public boolean isArrayType() {
        return arrayType;
    }

    public boolean isEnum() {
        return enumValues != null && enumValues.size() > 0;
    }

    public String getDescription() {
        return description;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public String getExample() {
        return example;
    }

    public List<String> getEnumValues() {
        return enumValues;
    }

    public String getAnnotatedDisplayName() {
        return annotatedDisplayName;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setSource(TypeSource source) {
        this.source = source;
    }

    public void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setArrayType(boolean arrayType) {
        this.arrayType = arrayType;
    }

    public void setUnionType(boolean unionType) {
        this.unionType = unionType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setAnnotatedDisplayName(String annotatedDisplayName) {
        this.annotatedDisplayName = annotatedDisplayName;
    }

    public void setExample(String example) {
        this.example = example;
    }
}
