package org.mule.connectivity.restconnect.internal.model.typesource;

public class PrimitiveTypeSource implements TypeSource {

    public enum PrimitiveType {

        BOOLEAN("boolean"),
        DATE("date"),
        DATE_ONLY("date-only"),
        DATE_TIME_ONLY("datetime-only"),
        DATE_TIME("datetime"),
        FILE("file"),
        NUMBER("number"),
        INTEGER("integer"),
        STRING("string"),
        TIME_ONLY("time-only");

        private final String type;

        PrimitiveType(String type) {
            this.type = type;
        }

        @Override
        public String toString() {
            return this.type;
        }

        public static PrimitiveType fromString(String type) {
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                if (primitiveType.type.equalsIgnoreCase(type)) {
                    return primitiveType;
                }
            }

            throw new IllegalArgumentException("No enum constant with text " + type + ".");
        }

    }

    private final PrimitiveType type;

    public PrimitiveTypeSource(PrimitiveType name) {
        this.type = name;
    }

    @Override
    public String getValue() {
        return null;
    }

    public PrimitiveType getType() {
        return this.type;
    }

}
