package org.mule.connectivity.restconnect.internal.modelGeneration;

import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

import java.util.HashMap;
import java.util.Map;

public class JsonSchemaPool {
    private Map<String, TypeDefinition> innerPool;

    public JsonSchemaPool(){
        this.innerPool = new HashMap<>();
    }

    public boolean containsSchema(String schema){
        return innerPool.keySet().stream().anyMatch(x -> x.equals(schema));
    }

    public TypeDefinition getTypeDefinitionForSchema(String schema) throws GenerationException {
        TypeDefinition typeDefinition = innerPool.get(schema);

        if(typeDefinition == null){
            throw new GenerationException("This json schema pool does not contain a type definition for the specified schema");
        }

        return typeDefinition;
    }

    public void putSchemaTypeDefinitionPair(String schema, TypeDefinition typeDefinition) throws GenerationException {
        if(this.containsSchema(schema)){
            throw new GenerationException("Schema already exists in json schema pool");
        }

        innerPool.put(schema, typeDefinition);
    }

    public void reset(){
        this.innerPool = new HashMap<>();
    }
}
